/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.delay.provider;

import java.util.Date;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.xmlpull.v1.XmlPullParser;

public abstract class AbstractDelayInformationProvider
implements PacketExtensionProvider {
    public final PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        String stampString = parser.getAttributeValue("", "stamp");
        String from = parser.getAttributeValue("", "from");
        String reason = null;
        if (!parser.isEmptyElementTag()) {
            int event = parser.next();
            switch (event) {
                case 4: {
                    reason = parser.getText();
                    parser.next();
                    break;
                }
                case 3: {
                    reason = "";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected event: " + event);
                }
            }
        } else {
            parser.next();
        }
        assert (parser.getEventType() == 3);
        Date stamp = this.parseDate(stampString);
        return new DelayInformation(stamp, from, reason);
    }

    protected abstract Date parseDate(String var1) throws Exception;
}

