/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.InputStream;
import java.io.OutputStream;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public abstract class StreamNegotiator {
    public StreamInitiation createInitiationAccept(StreamInitiation streamInitiationOffer, String[] namespaces) {
        StreamInitiation response = new StreamInitiation();
        response.setTo(streamInitiationOffer.getFrom());
        response.setFrom(streamInitiationOffer.getTo());
        response.setType(IQ.Type.result);
        response.setPacketID(streamInitiationOffer.getPacketID());
        DataForm form = new DataForm("submit");
        FormField field = new FormField("stream-method");
        for (String namespace : namespaces) {
            field.addValue(namespace);
        }
        form.addField(field);
        response.setFeatureNegotiationForm(form);
        return response;
    }

    Packet initiateIncomingStream(XMPPConnection connection, StreamInitiation initiation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        StreamInitiation response = this.createInitiationAccept(initiation, this.getNamespaces());
        PacketCollector collector = connection.createPacketCollector(this.getInitiationPacketFilter(initiation.getFrom(), initiation.getSessionID()));
        connection.sendPacket((Packet)response);
        Packet streamMethodInitiation = collector.nextResultOrThrow();
        return streamMethodInitiation;
    }

    public abstract PacketFilter getInitiationPacketFilter(String var1, String var2);

    abstract InputStream negotiateIncomingStream(Packet var1) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NoResponseException, SmackException;

    public abstract InputStream createIncomingStream(StreamInitiation var1) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NoResponseException, SmackException;

    public abstract OutputStream createOutgoingStream(String var1, String var2, String var3) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException, XMPPException;

    public abstract String[] getNamespaces();
}

