/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.muc.provider.MUCParserUtils;
import org.xmlpull.v1.XmlPullParser;

public class MUCUserProvider
implements PacketExtensionProvider {
    /*
     * Enabled aggressive block sorting
     */
    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        int initialDepth = parser.getDepth();
        MUCUser mucUser = new MUCUser();
        while (true) {
            block0 : switch (parser.next()) {
                case 2: {
                    switch (parser.getName()) {
                        case "invite": {
                            mucUser.setInvite(MUCUserProvider.parseInvite(parser));
                            break block0;
                        }
                        case "item": {
                            mucUser.setItem(MUCParserUtils.parseItem(parser));
                            break block0;
                        }
                        case "password": {
                            mucUser.setPassword(parser.nextText());
                            break block0;
                        }
                        case "status": {
                            String statusString = parser.getAttributeValue("", "code");
                            mucUser.addStatusCode(MUCUser.Status.create(statusString));
                            break block0;
                        }
                        case "decline": {
                            mucUser.setDecline(MUCUserProvider.parseDecline(parser));
                            break block0;
                        }
                        case "destroy": {
                            mucUser.setDestroy(MUCParserUtils.parseDestroy(parser));
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    if (parser.getDepth() != initialDepth) break;
                    return mucUser;
                }
            }
        }
    }

    private static MUCUser.Invite parseInvite(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setFrom(parser.getAttributeValue("", "from"));
        invite.setTo(parser.getAttributeValue("", "to"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                invite.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("invite")) continue;
            done = true;
        }
        return invite;
    }

    private static MUCUser.Decline parseDecline(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setFrom(parser.getAttributeValue("", "from"));
        decline.setTo(parser.getAttributeValue("", "to"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                decline.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("decline")) continue;
            done = true;
        }
        return decline;
    }
}

