/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.xmlpull.v1.XmlPullParser;

class SimpleUserSearch
extends IQ {
    private Form form;
    private ReportedData data;

    SimpleUserSearch() {
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public ReportedData getReportedData() {
        return this.data;
    }

    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<query xmlns=\"jabber:iq:search\">");
        buf.append(this.getItemsToSearch());
        buf.append("</query>");
        return buf.toString();
    }

    private String getItemsToSearch() {
        StringBuilder buf = new StringBuilder();
        if (this.form == null) {
            this.form = Form.getFormFrom((Packet)this);
        }
        if (this.form == null) {
            return "";
        }
        for (FormField field : this.form.getFields()) {
            String name = field.getVariable();
            String value = SimpleUserSearch.getSingleValue(field);
            if (value.trim().length() <= 0) continue;
            buf.append("<").append(name).append(">").append(value).append("</").append(name).append(">");
        }
        return buf.toString();
    }

    private static String getSingleValue(FormField formField) {
        List<String> values = formField.getValues();
        if (values.isEmpty()) {
            return "";
        }
        return values.get(0);
    }

    protected void parseItems(XmlPullParser parser) throws Exception {
        ReportedData data = new ReportedData();
        data.addColumn(new ReportedData.Column("JID", "jid", "text-single"));
        boolean done = false;
        ArrayList<ReportedData.Field> fields = new ArrayList<ReportedData.Field>();
        while (!done) {
            int eventType;
            if (parser.getAttributeCount() > 0) {
                String jid = parser.getAttributeValue("", "jid");
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(jid);
                ReportedData.Field field = new ReportedData.Field("jid", valueList);
                fields.add(field);
            }
            if ((eventType = parser.next()) == 2 && parser.getName().equals("item")) {
                fields = new ArrayList();
                continue;
            }
            if (eventType == 3 && parser.getName().equals("item")) {
                ReportedData.Row row = new ReportedData.Row(fields);
                data.addRow(row);
                continue;
            }
            if (eventType == 2) {
                String name = parser.getName();
                String value = parser.nextText();
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                ReportedData.Field field = new ReportedData.Field(name, valueList);
                fields.add(field);
                boolean exists = false;
                for (ReportedData.Column column : data.getColumns()) {
                    if (!column.getVariable().equals(name)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                ReportedData.Column column = new ReportedData.Column(name, name, "text-single");
                data.addColumn(column);
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        this.data = data;
    }
}

