/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.provider;

import java.util.ArrayList;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.xmlpull.v1.XmlPullParser;

public class DataFormProvider
implements PacketExtensionProvider {
    public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
        boolean done = false;
        DataForm dataForm = new DataForm(parser.getAttributeValue("", "type"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("instructions")) {
                    dataForm.addInstruction(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("title")) {
                    dataForm.setTitle(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("field")) {
                    dataForm.addField(this.parseField(parser));
                    continue;
                }
                if (parser.getName().equals("item")) {
                    dataForm.addItem(this.parseItem(parser));
                    continue;
                }
                if (parser.getName().equals("reported")) {
                    dataForm.setReportedData(this.parseReported(parser));
                    continue;
                }
                if (!parser.getName().equals("query") || !parser.getNamespace().equals("jabber:iq:roster")) continue;
                dataForm.addExtensionElement((Element)PacketParserUtils.parseRoster((XmlPullParser)parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals(dataForm.getElementName())) continue;
            done = true;
        }
        return dataForm;
    }

    private FormField parseField(XmlPullParser parser) throws Exception {
        boolean done = false;
        FormField formField = new FormField(parser.getAttributeValue("", "var"));
        formField.setLabel(parser.getAttributeValue("", "label"));
        formField.setType(parser.getAttributeValue("", "type"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("desc")) {
                    formField.setDescription(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("value")) {
                    formField.addValue(parser.nextText());
                    continue;
                }
                if (parser.getName().equals("required")) {
                    formField.setRequired(true);
                    continue;
                }
                if (!parser.getName().equals("option")) continue;
                formField.addOption(this.parseOption(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("field")) continue;
            done = true;
        }
        return formField;
    }

    private DataForm.Item parseItem(XmlPullParser parser) throws Exception {
        boolean done = false;
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("field")) continue;
                fields.add(this.parseField(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("item")) continue;
            done = true;
        }
        return new DataForm.Item(fields);
    }

    private DataForm.ReportedData parseReported(XmlPullParser parser) throws Exception {
        boolean done = false;
        ArrayList<FormField> fields = new ArrayList<FormField>();
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("field")) continue;
                fields.add(this.parseField(parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("reported")) continue;
            done = true;
        }
        return new DataForm.ReportedData(fields);
    }

    private FormField.Option parseOption(XmlPullParser parser) throws Exception {
        boolean done = false;
        FormField.Option option = null;
        String label = parser.getAttributeValue("", "label");
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("value")) continue;
                option = new FormField.Option(label, parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("option")) continue;
            done = true;
        }
        return option;
    }
}

