/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.ibb.DataListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;

public class DataListenerTest {
    String initiatorJID = "initiator@xmpp-server/Smack";
    String targetJID = "target@xmpp-server/Smack";

    @Test
    public void shouldReplyErrorIfSessionIsUnknown() throws Exception {
        XMPPConnection connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)connection);
        DataListener dataListener = (DataListener)Whitebox.getInternalState((Object)byteStreamManager, DataListener.class);
        DataPacketExtension dpe = new DataPacketExtension("unknownSessionID", 0L, "Data");
        Data data = new Data(dpe);
        data.setFrom(this.initiatorJID);
        data.setTo(this.targetJID);
        dataListener.processPacket((Packet)data);
        Thread.sleep(200L);
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)connection)).sendPacket((Packet)argument.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.item_not_found.toString(), (Object)((IQ)argument.getValue()).getError().getCondition());
    }
}

