/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5TestProxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Socks5ClientForInitiatorTest {
    String initiatorJID = "initiator@xmpp-server/Smack";
    String targetJID = "target@xmpp-server/Smack";
    String xmppServer = "xmpp-server";
    String proxyJID = "proxy.xmpp-server";
    String proxyAddress = "127.0.0.1";
    int proxyPort = 7890;
    String sessionID = "session_id";
    Protocol protocol;
    XMPPConnection connection;

    @Before
    public void setup() throws XMPPException, SmackException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection(this.protocol, this.initiatorJID, this.xmppServer);
    }

    @Test
    public void shouldFailIfTargetIsNotConnectedToLocalSocks5Proxy() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyPort((int)this.proxyPort);
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        socks5Proxy.start();
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost(this.connection.getUser(), (String)socks5Proxy.getLocalAddresses().get(0), socks5Proxy.getPort());
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, this.targetJID);
        try {
            socks5Client.getSocket(10000);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("target is not connected to SOCKS5 proxy"));
            this.protocol.verifyAll();
        }
        socks5Proxy.stop();
    }

    @Test
    public void shouldSuccessfullyConnectThroughLocalSocks5Proxy() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyPort((int)this.proxyPort);
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        socks5Proxy.start();
        final byte[] data = new byte[]{1, 2, 3};
        final String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        socks5Proxy.addTransfer(digest);
        final Bytestream.StreamHost streamHost = new Bytestream.StreamHost(this.connection.getUser(), (String)socks5Proxy.getLocalAddresses().get(0), socks5Proxy.getPort());
        Thread targetThread = new Thread(){

            @Override
            public void run() {
                try {
                    Socks5Client targetClient = new Socks5Client(streamHost, digest);
                    Socket socket = targetClient.getSocket(10000);
                    socket.getOutputStream().write(data);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        targetThread.start();
        Thread.sleep(200L);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, this.targetJID);
        Socket socket = socks5Client.getSocket(10000);
        InputStream in = socket.getInputStream();
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((long)data[i], (long)in.read());
        }
        targetThread.join();
        this.protocol.verifyAll();
        socks5Proxy.removeTransfer(digest);
        socks5Proxy.stop();
    }

    @Test
    public void shouldFailIfActivateSocks5ProxyFails() throws Exception {
        XMPPError xmppError = new XMPPError(XMPPError.Condition.internal_server_error);
        IQ error = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        error.setType(IQ.Type.error);
        error.setFrom(this.proxyJID);
        error.setTo(this.initiatorJID);
        error.setError(xmppError);
        this.protocol.addResponse((Packet)error, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(this.proxyPort);
        socks5Proxy.start();
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost(this.proxyJID, socks5Proxy.getAddress(), socks5Proxy.getPort());
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, this.targetJID);
        try {
            socks5Client.getSocket(10000);
            Assert.fail((String)"exception should be thrown");
        }
        catch (XMPPException.XMPPErrorException e) {
            Assert.assertTrue((boolean)XMPPError.Condition.internal_server_error.equals((CharSequence)e.getXMPPError().getCondition()));
            this.protocol.verifyAll();
        }
        socks5Proxy.stop();
    }

    @Test
    public void shouldSuccessfullyEstablishConnectionAndActivateSocks5Proxy() throws Exception {
        IQ activationResponse = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        activationResponse.setFrom(this.proxyJID);
        activationResponse.setTo(this.initiatorJID);
        activationResponse.setType(IQ.Type.result);
        this.protocol.addResponse((Packet)activationResponse, Verification.correspondingSenderReceiver, Verification.requestTypeSET, new Verification<Bytestream, IQ>(){

            @Override
            public void verify(Bytestream request, IQ response) {
                Assert.assertNotNull((Object)request.getToActivate());
                Assert.assertEquals((Object)Socks5ClientForInitiatorTest.this.targetJID, (Object)request.getToActivate().getTarget());
            }
        });
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(this.proxyPort);
        socks5Proxy.start();
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost(this.proxyJID, socks5Proxy.getAddress(), socks5Proxy.getPort());
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, this.targetJID);
        Socket initiatorSocket = socks5Client.getSocket(10000);
        InputStream in = initiatorSocket.getInputStream();
        Socket targetSocket = socks5Proxy.getSocket(digest);
        OutputStream out = targetSocket.getOutputStream();
        for (int i = 0; i < 10; ++i) {
            out.write(i);
            Assert.assertEquals((long)i, (long)in.read());
        }
        this.protocol.verifyAll();
        initiatorSocket.close();
        targetSocket.close();
        socks5Proxy.stop();
    }

    @After
    public void cleanup() {
        Socks5Proxy.setLocalSocks5ProxyPort((int)7777);
    }
}

