/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.muc.ConnectionDetachedPacketCollector;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionDetachedPacketCollectorTest {
    @Test
    public void verifyRollover() {
        TestPacket testPacket;
        int i;
        ConnectionDetachedPacketCollector collector = new ConnectionDetachedPacketCollector(5);
        for (i = 0; i < 6; ++i) {
            testPacket = new TestPacket(i);
            collector.processPacket((Packet)testPacket);
        }
        Assert.assertEquals((Object)"1", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"2", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"3", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"4", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"5", (Object)collector.pollResult().getPacketID());
        Assert.assertNull((Object)collector.pollResult());
        for (i = 10; i < 15; ++i) {
            testPacket = new TestPacket(i);
            collector.processPacket((Packet)testPacket);
        }
        Assert.assertEquals((Object)"10", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"11", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"12", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"13", (Object)collector.nextResult().getPacketID());
        Assert.assertEquals((Object)"14", (Object)collector.pollResult().getPacketID());
        Assert.assertNull((Object)collector.pollResult());
        Assert.assertNull((Object)collector.nextResult(1000L));
    }

    @Test
    public void verifyThreadSafety() {
        int insertCount = 500;
        final ConnectionDetachedPacketCollector collector = new ConnectionDetachedPacketCollector(insertCount);
        Thread consumer1 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            Thread.sleep(3L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        Packet packet = collector.nextResult();
                    }
                }
                catch (RuntimeException re) {
                    if (re.getCause() instanceof InterruptedException) {
                        // empty if block
                    }
                    return;
                }
            }
        });
        consumer1.setName("consumer 1");
        Thread consumer2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Packet p = null;
                do {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((p = collector.nextResult(1L)) != null);
            }
        });
        consumer2.setName("consumer 2");
        Thread consumer3 = new Thread(new Runnable(){

            @Override
            public void run() {
                Packet p = null;
                do {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((p = collector.pollResult()) != null);
            }
        });
        consumer3.setName("consumer 3");
        consumer1.start();
        consumer2.start();
        consumer3.start();
        for (int i = 0; i < insertCount; ++i) {
            collector.processPacket((Packet)new TestPacket(i));
        }
        try {
            Thread.sleep(5000L);
            consumer3.join();
            consumer2.join();
            consumer1.interrupt();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertNull((Object)collector.pollResult());
    }

    class TestPacket
    extends Packet {
        public TestPacket(int i) {
            this.setPacketID(String.valueOf(i));
        }

        public String toString() {
            return this.toXML();
        }

        public String toXML() {
            return "<packetId>" + this.getPacketID() + "</packetId>";
        }
    }
}

