/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.time.packet.Time;
import org.junit.Assert;
import org.junit.Test;

public class TimeTest
extends InitExtensions {
    @Test
    public void parseCurrentTimeTest() {
        Calendar calendar = Calendar.getInstance();
        Time time = new Time(calendar);
        Date date = time.getTime();
        Date calendarDate = calendar.getTime();
        Assert.assertEquals((Object)calendarDate, (Object)date);
    }

    @Test
    public void negativeTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT-830"));
        Time time = new Time(calendar);
        Assert.assertEquals((Object)"-8:30", (Object)time.getTzo());
    }

    @Test
    public void positiveTimezoneTest() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT+830"));
        Time time = new Time(calendar);
        Assert.assertEquals((Object)"+8:30", (Object)time.getTzo());
    }

    @Test
    public void parseTimeWithIntrospectionTest() throws Exception {
        String request = "<iq type='get'from='romeo@montague.net/orchard'to='juliet@capulet.com/balcony'id='time_1'><time xmlns='urn:xmpp:time'/></iq>";
        IQ iqRequest = (IQ)PacketParserUtils.parseStanza((String)"<iq type='get'from='romeo@montague.net/orchard'to='juliet@capulet.com/balcony'id='time_1'><time xmlns='urn:xmpp:time'/></iq>");
        Assert.assertTrue((boolean)(iqRequest instanceof Time));
        String response = "<iq type='result'from='juliet@capulet.com/balcony'to='romeo@montague.net/orchard'id='time_1'><time xmlns='urn:xmpp:time'><tzo>-06:00</tzo><utc>2006-12-19T17:58:35Z</utc></time></iq>";
        IQ iqResponse = (IQ)PacketParserUtils.parseStanza((String)"<iq type='result'from='juliet@capulet.com/balcony'to='romeo@montague.net/orchard'id='time_1'><time xmlns='urn:xmpp:time'><tzo>-06:00</tzo><utc>2006-12-19T17:58:35Z</utc></time></iq>");
        Assert.assertTrue((boolean)(iqResponse instanceof Time));
        Time time = (Time)iqResponse;
        Assert.assertEquals((Object)"-06:00", (Object)time.getTzo());
        Assert.assertEquals((Object)"2006-12-19T17:58:35Z", (Object)time.getUtc());
    }
}

