/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.time.packet.Time;

public class EntityTimeManager
extends Manager {
    private static final Map<XMPPConnection, EntityTimeManager> INSTANCES = new WeakHashMap<XMPPConnection, EntityTimeManager>();
    private static final PacketFilter TIME_PACKET_FILTER = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Time.class), IQTypeFilter.GET});
    private static boolean autoEnable = true;
    private boolean enabled = false;

    public static void setAutoEnable(boolean autoEnable) {
        EntityTimeManager.autoEnable = autoEnable;
    }

    public static synchronized EntityTimeManager getInstanceFor(XMPPConnection connection) {
        EntityTimeManager entityTimeManager = INSTANCES.get(connection);
        if (entityTimeManager == null) {
            entityTimeManager = new EntityTimeManager(connection);
            INSTANCES.put(connection, entityTimeManager);
        }
        return entityTimeManager;
    }

    private EntityTimeManager(XMPPConnection connection) {
        super(connection);
        if (autoEnable) {
            this.enable();
        }
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                if (!EntityTimeManager.this.enabled) {
                    return;
                }
                EntityTimeManager.this.connection().sendPacket((Packet)Time.createResponse(packet));
            }
        }, TIME_PACKET_FILTER);
    }

    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        sdm.addFeature("urn:xmpp:time");
        this.enabled = true;
    }

    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        sdm.removeFeature("urn:xmpp:time");
        this.enabled = false;
    }

    public boolean isTimeSupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:time");
    }

    public Time getTime(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.isTimeSupported(jid)) {
            return null;
        }
        Time request = new Time();
        Time response = (Time)this.connection().createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                EntityTimeManager.getInstanceFor(connection);
            }
        });
    }
}

