/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptManager;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;

public class DeliveryReceiptTest
extends InitExtensions {
    private static Properties outputProperties = new Properties();

    @Test
    public void receiptTest() throws Exception {
        String control = XMLBuilder.create((String)"message").a("from", "romeo@montague.com").e("request").a("xmlns", "urn:xmpp:receipts").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Message p = PacketParserUtils.parseMessage((XmlPullParser)parser);
        DeliveryReceiptRequest drr = (DeliveryReceiptRequest)p.getExtension("request", "urn:xmpp:receipts");
        Assert.assertNotNull((Object)drr);
        Assert.assertTrue((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Packet)p));
        Message m = new Message("romeo@montague.com", Message.Type.normal);
        Assert.assertFalse((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Packet)m));
        DeliveryReceiptRequest.addTo((Message)m);
        Assert.assertTrue((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Packet)m));
    }

    @Test
    public void receiptManagerListenerTest() throws Exception {
        DummyConnection c = new DummyConnection();
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)c);
        DeliveryReceiptManager drm = DeliveryReceiptManager.getInstanceFor((XMPPConnection)c);
        TestReceiptReceivedListener rrl = new TestReceiptReceivedListener();
        drm.addReceiptReceivedListener((ReceiptReceivedListener)rrl);
        Message m = new Message("romeo@montague.com", Message.Type.normal);
        m.setFrom("julia@capulet.com");
        m.setPacketID("reply-id");
        m.addExtension((PacketExtension)new DeliveryReceipt("original-test-id"));
        drm.processPacket((Packet)m);
        Assert.assertEquals((Object)"original-test-id", (Object)rrl.receiptId);
    }

    @Test
    public void receiptManagerAutoReplyTest() throws Exception {
        DummyConnection c = new DummyConnection();
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)c);
        DeliveryReceiptManager drm = DeliveryReceiptManager.getInstanceFor((XMPPConnection)c);
        drm.enableAutoReceipts();
        Assert.assertTrue((boolean)drm.getAutoReceiptsEnabled());
        Message m = new Message("julia@capulet.com", Message.Type.normal);
        m.setFrom("romeo@montague.com");
        m.setPacketID("test-receipt-request");
        DeliveryReceiptRequest.addTo((Message)m);
        Assert.assertEquals((long)0L, (long)c.getNumberOfSentPackets());
        drm.processPacket((Packet)m);
        Assert.assertEquals((long)1L, (long)c.getNumberOfSentPackets());
        Packet reply = c.getSentPacket();
        DeliveryReceipt r = (DeliveryReceipt)reply.getExtension("received", "urn:xmpp:receipts");
        Assert.assertEquals((Object)"romeo@montague.com", (Object)reply.getTo());
        Assert.assertEquals((Object)"test-receipt-request", (Object)r.getId());
    }

    static {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    private static class TestReceiptReceivedListener
    implements ReceiptReceivedListener {
        public String receiptId = null;

        private TestReceiptReceivedListener() {
        }

        public void onReceiptReceived(String fromJid, String toJid, String receiptId, Packet receipt) {
            Assert.assertEquals((Object)"julia@capulet.com", (Object)fromJid);
            Assert.assertEquals((Object)"romeo@montague.com", (Object)toJid);
            Assert.assertEquals((Object)"original-test-id", (Object)receiptId);
            this.receiptId = receiptId;
        }
    }
}

