/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.custommonkey.xmlunit.XMLAssert;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.junit.Assert;
import org.junit.Test;

public class OpenTest {
    private static Properties outputProperties = new Properties();

    public OpenTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArguments1() {
        new Open(null, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArguments2() {
        new Open("", 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArguments3() {
        new Open("sessionID", -1);
    }

    @Test
    public void shouldSetIQStanzaAsDefault() {
        Open open = new Open("sessionID", 4096);
        Assert.assertEquals((Object)InBandBytestreamManager.StanzaType.IQ, (Object)open.getStanza());
    }

    @Test
    public void shouldUseMessageStanzaIfGiven() {
        Open open = new Open("sessionID", 4096, InBandBytestreamManager.StanzaType.MESSAGE);
        Assert.assertEquals((Object)InBandBytestreamManager.StanzaType.MESSAGE, (Object)open.getStanza());
    }

    @Test
    public void shouldBeOfIQTypeSET() {
        Open open = new Open("sessionID", 4096);
        Assert.assertEquals((Object)IQ.Type.set, (Object)open.getType());
    }

    @Test
    public void shouldSetAllFieldsCorrectly() {
        Open open = new Open("sessionID", 4096, InBandBytestreamManager.StanzaType.MESSAGE);
        Assert.assertEquals((Object)"sessionID", (Object)open.getSessionID());
        Assert.assertEquals((long)4096L, (long)open.getBlockSize());
        Assert.assertEquals((Object)InBandBytestreamManager.StanzaType.MESSAGE, (Object)open.getStanza());
    }

    @Test
    public void shouldReturnValidIQStanzaXML() throws Exception {
        String control = XMLBuilder.create((String)"iq").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "jn3h8g65").a("type", "set").e("open").a("xmlns", "http://jabber.org/protocol/ibb").a("block-size", "4096").a("sid", "i781hf64").a("stanza", "iq").asString(outputProperties);
        Open open = new Open("i781hf64", 4096, InBandBytestreamManager.StanzaType.IQ);
        open.setFrom("romeo@montague.lit/orchard");
        open.setTo("juliet@capulet.lit/balcony");
        open.setPacketID("jn3h8g65");
        XMLAssert.assertXMLEqual((String)control, (String)open.toXML().toString());
    }
}

