/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InitiationListener;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.reflect.Whitebox;

public class InitiationListenerTest {
    String initiatorJID = "initiator@xmpp-server/Smack";
    String targetJID = "target@xmpp-server/Smack";
    String sessionID = "session_id";
    XMPPConnection connection;
    InBandBytestreamManager byteStreamManager;
    InitiationListener initiationListener;
    Open initBytestream;

    @Before
    public void setup() {
        this.connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        this.byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        this.initiationListener = (InitiationListener)Whitebox.getInternalState((Object)this.byteStreamManager, InitiationListener.class);
        this.initBytestream = new Open(this.sessionID, 4096);
        this.initBytestream.setFrom(this.initiatorJID);
        this.initBytestream.setTo(this.targetJID);
    }

    @Test
    public void shouldRespondWithError() throws Exception {
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendPacket((Packet)argument.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.not_acceptable, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldRejectRequestWithTooBigBlockSize() throws Exception {
        this.byteStreamManager.setMaximumBlockSize(1024);
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendPacket((Packet)argument.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.resource_constraint, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldInvokeListenerForAllRequests() throws Exception {
        InBandBytestreamListener listener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener);
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)listener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldInvokeListenerForUser() throws Exception {
        InBandBytestreamListener listener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, this.initiatorJID);
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)listener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldNotInvokeListenerForUser() throws Exception {
        InBandBytestreamListener listener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, "other_" + this.initiatorJID);
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendPacket((Packet)argument.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.not_acceptable, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldNotInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        InBandBytestreamListener allRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        InBandBytestreamListener userRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, this.initiatorJID);
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        InBandBytestreamListener allRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        InBandBytestreamListener userRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, "other_" + this.initiatorJID);
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldIgnoreInBandBytestreamRequestOnce() throws Exception {
        InBandBytestreamListener allRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        InBandBytestreamListener userRequestsListener = (InBandBytestreamListener)Mockito.mock(InBandBytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, this.initiatorJID);
        this.byteStreamManager.ignoreBytestreamRequestOnce(this.sessionID);
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        this.initiationListener.processPacket((Packet)this.initBytestream);
        Thread.sleep(200L);
        ((InBandBytestreamListener)Mockito.verify((Object)userRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((InBandBytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }
}

