/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5PacketUtils;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5TestProxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class Socks5ByteStreamManagerTest {
    String initiatorJID = "initiator@xmpp-server/Smack";
    String targetJID = "target@xmpp-server/Smack";
    String xmppServer = "xmpp-server";
    String proxyJID = "proxy.xmpp-server";
    String proxyAddress = "127.0.0.1";
    String sessionID = "session_id";
    Protocol protocol;
    XMPPConnection connection;

    @Before
    public void setup() throws XMPPException, SmackException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection(this.protocol, this.initiatorJID, this.xmppServer);
    }

    @Test
    public void shouldHaveOneManagerForEveryConnection() {
        XMPPConnection connection1 = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        XMPPConnection connection2 = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection1);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection2);
        Socks5BytestreamManager conn1ByteStreamManager1 = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection1);
        Socks5BytestreamManager conn1ByteStreamManager2 = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection1);
        Socks5BytestreamManager conn2ByteStreamManager1 = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection2);
        Assert.assertEquals((Object)conn1ByteStreamManager1, (Object)conn1ByteStreamManager2);
        Assert.assertNotSame((Object)conn1ByteStreamManager1, (Object)conn2ByteStreamManager1);
    }

    @Test
    public void shouldDisableService() {
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection);
        Assert.assertTrue((boolean)discoveryManager.includesFeature("http://jabber.org/protocol/bytestreams"));
        byteStreamManager.disableService();
        Assert.assertFalse((boolean)discoveryManager.includesFeature("http://jabber.org/protocol/bytestreams"));
    }

    @Test
    public void shouldFailIfTargetDoesNotSupportSocks5() throws XMPPException {
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        try {
            DiscoverInfo discoverInfo = new DiscoverInfo();
            this.protocol.addResponse((Packet)discoverInfo, new Verification[0]);
            byteStreamManager.establishSession(this.targetJID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException.FeatureNotSupportedException e) {
            Assert.assertTrue((boolean)e.getFeature().equals("SOCKS5 Bytestream"));
            Assert.assertTrue((boolean)e.getJid().equals(this.targetJID));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void shouldFailIfNoSocks5ProxyFound1() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        try {
            byteStreamManager.establishSession(this.targetJID, this.sessionID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException e) {
            this.protocol.verifyAll();
            Assert.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void shouldFailIfNoSocks5ProxyFound2() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item(this.proxyJID);
        discoverItems.addItem(item);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo = Socks5PacketUtils.createDiscoverInfo(this.proxyJID, this.initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("noproxy", this.proxyJID, "bytestreams");
        proxyInfo.addIdentity(identity);
        this.protocol.addResponse((Packet)proxyInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        try {
            byteStreamManager.establishSession(this.targetJID, this.sessionID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException e) {
            this.protocol.verifyAll();
            Assert.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void shouldBlacklistNonSocks5Proxies() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item(this.proxyJID);
        discoverItems.addItem(item);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo = Socks5PacketUtils.createDiscoverInfo(this.proxyJID, this.initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("noproxy", this.proxyJID, "bytestreams");
        proxyInfo.addIdentity(identity);
        this.protocol.addResponse((Packet)proxyInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        try {
            byteStreamManager.establishSession(this.targetJID, this.sessionID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException e) {
            this.protocol.verifyAll();
            Assert.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        try {
            byteStreamManager.establishSession(this.targetJID, this.sessionID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException e) {
            this.protocol.verifyAll();
            Assert.assertTrue((boolean)e.getMessage().contains("no SOCKS5 proxies available"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void shouldFailIfTargetDoesNotAcceptSocks5Bytestream() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item(this.proxyJID);
        discoverItems.addItem(item);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo = Socks5PacketUtils.createDiscoverInfo(this.proxyJID, this.initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", this.proxyJID, "bytestreams");
        proxyInfo.addIdentity(identity);
        this.protocol.addResponse((Packet)proxyInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse(this.proxyJID, this.initiatorJID);
        streamHostInfo.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
        this.protocol.addResponse((Packet)streamHostInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        XMPPError xmppError = new XMPPError(XMPPError.Condition.not_acceptable);
        ErrorIQ rejectPacket = new ErrorIQ(xmppError);
        rejectPacket.setFrom(this.targetJID);
        rejectPacket.setTo(this.initiatorJID);
        rejectPacket.setError(xmppError);
        this.protocol.addResponse((Packet)rejectPacket, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        try {
            byteStreamManager.establishSession(this.targetJID, this.sessionID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (XMPPException.XMPPErrorException e) {
            this.protocol.verifyAll();
            Assert.assertEquals((Object)xmppError, (Object)e.getXMPPError());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void shouldFailIfTargetUsesInvalidSocks5Proxy() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item(this.proxyJID);
        discoverItems.addItem(item);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo = Socks5PacketUtils.createDiscoverInfo(this.proxyJID, this.initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", this.proxyJID, "bytestreams");
        proxyInfo.addIdentity(identity);
        this.protocol.addResponse((Packet)proxyInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse(this.proxyJID, this.initiatorJID);
        streamHostInfo.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
        this.protocol.addResponse((Packet)streamHostInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse(this.targetJID, this.initiatorJID);
        streamHostUsedPacket.setSessionID(this.sessionID);
        streamHostUsedPacket.setUsedHost("invalid.proxy");
        this.protocol.addResponse((Packet)streamHostUsedPacket, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        try {
            byteStreamManager.establishSession(this.targetJID, this.sessionID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException e) {
            this.protocol.verifyAll();
            Assert.assertTrue((boolean)e.getMessage().contains("Remote user responded with unknown host"));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void shouldFailIfInitiatorCannotConnectToSocks5Proxy() {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item(this.proxyJID);
        discoverItems.addItem(item);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo = Socks5PacketUtils.createDiscoverInfo(this.proxyJID, this.initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", this.proxyJID, "bytestreams");
        proxyInfo.addIdentity(identity);
        this.protocol.addResponse((Packet)proxyInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse(this.proxyJID, this.initiatorJID);
        streamHostInfo.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
        this.protocol.addResponse((Packet)streamHostInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse(this.targetJID, this.initiatorJID);
        streamHostUsedPacket.setSessionID(this.sessionID);
        streamHostUsedPacket.setUsedHost(this.proxyJID);
        this.protocol.addResponse((Packet)streamHostUsedPacket, new Verification<Bytestream, Bytestream>(){

            @Override
            public void verify(Bytestream request, Bytestream response) {
                Assert.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assert.assertEquals((long)1L, (long)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[0];
                Assert.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        try {
            byteStreamManager.establishSession(this.targetJID, this.sessionID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (IOException e) {
            this.protocol.verifyAll();
            Assert.assertEquals(ConnectException.class, e.getClass());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void shouldNegotiateSocks5BytestreamAndTransferData() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        DiscoverItems.Item item = new DiscoverItems.Item(this.proxyJID);
        discoverItems.addItem(item);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo = Socks5PacketUtils.createDiscoverInfo(this.proxyJID, this.initiatorJID);
        DiscoverInfo.Identity identity = new DiscoverInfo.Identity("proxy", this.proxyJID, "bytestreams");
        proxyInfo.addIdentity(identity);
        this.protocol.addResponse((Packet)proxyInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostInfo = Socks5PacketUtils.createBytestreamResponse(this.proxyJID, this.initiatorJID);
        streamHostInfo.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
        this.protocol.addResponse((Packet)streamHostInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse(this.targetJID, this.initiatorJID);
        streamHostUsedPacket.setSessionID(this.sessionID);
        streamHostUsedPacket.setUsedHost(this.proxyJID);
        this.protocol.addResponse((Packet)streamHostUsedPacket, new Verification<Bytestream, Bytestream>(){

            @Override
            public void verify(Bytestream request, Bytestream response) {
                Assert.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assert.assertEquals((long)1L, (long)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[0];
                Assert.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        IQ activationResponse = Socks5PacketUtils.createActivationConfirmation(this.proxyJID, this.initiatorJID);
        this.protocol.addResponse((Packet)activationResponse, new Verification<Bytestream, IQ>(){

            @Override
            public void verify(Bytestream request, IQ response) {
                Assert.assertEquals((Object)Socks5ByteStreamManagerTest.this.targetJID, (Object)request.getToActivate().getTarget());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(7778);
        socks5Proxy.start();
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        OutputStream outputStream = byteStreamManager.establishSession(this.targetJID, this.sessionID).getOutputStream();
        InputStream inputStream = socks5Proxy.getSocket(digest).getInputStream();
        byte[] data = new byte[]{1, 2, 3};
        outputStream.write(data);
        byte[] result = new byte[3];
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        this.protocol.verifyAll();
    }

    @Test
    public void shouldUseMultipleAddressesForLocalSocks5Proxy() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)true);
        Socks5Proxy.setLocalSocks5ProxyPort((int)7778);
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        socks5Proxy.start();
        Assert.assertTrue((boolean)socks5Proxy.isRunning());
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse(this.targetJID, this.initiatorJID);
        streamHostUsedPacket.setSessionID(this.sessionID);
        streamHostUsedPacket.setUsedHost(this.initiatorJID);
        this.protocol.addResponse((Packet)streamHostUsedPacket, new Verification<Bytestream, Bytestream>(){

            @Override
            public void verify(Bytestream request, Bytestream response) {
                Assert.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Bytestream.StreamHost streamHost1 = (Bytestream.StreamHost)request.getStreamHosts().get(0);
                Assert.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost1.getJID());
                Bytestream.StreamHost streamHost2 = (Bytestream.StreamHost)request.getStreamHosts().get(request.getStreamHosts().size() - 1);
                Assert.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost2.getJID());
                Assert.assertEquals((Object)"localAddress", (Object)streamHost2.getAddress());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        socks5Proxy.addTransfer(digest);
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost(this.targetJID, (String)socks5Proxy.getLocalAddresses().get(0), socks5Proxy.getPort());
        Socks5Client socks5Client = new Socks5Client(streamHost, digest);
        InputStream inputStream = socks5Client.getSocket(2000).getInputStream();
        socks5Proxy.addLocalAddress("localAddress");
        OutputStream outputStream = byteStreamManager.establishSession(this.targetJID, this.sessionID).getOutputStream();
        byte[] data = new byte[]{1, 2, 3};
        outputStream.write(data);
        byte[] result = new byte[3];
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        this.protocol.verifyAll();
        socks5Proxy.stop();
        socks5Proxy.removeLocalAddress("localAddress");
        Socks5Proxy.setLocalSocks5ProxyPort((int)7777);
    }

    @Test
    public void shouldPrioritizeSecondSocks5ProxyOnSecondAttempt() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        Assert.assertTrue((boolean)byteStreamManager.isProxyPrioritizationEnabled());
        Verification<Bytestream, Bytestream> streamHostUsedVerification1 = new Verification<Bytestream, Bytestream>(){

            @Override
            public void verify(Bytestream request, Bytestream response) {
                Assert.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assert.assertEquals((long)2L, (long)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[1];
                Assert.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        };
        this.createResponses(streamHostUsedVerification1);
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(7778);
        socks5Proxy.start();
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        OutputStream outputStream = byteStreamManager.establishSession(this.targetJID, this.sessionID).getOutputStream();
        InputStream inputStream = socks5Proxy.getSocket(digest).getInputStream();
        byte[] data = new byte[]{1, 2, 3};
        outputStream.write(data);
        byte[] result = new byte[3];
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        this.protocol.verifyAll();
        Verification<Bytestream, Bytestream> streamHostUsedVerification2 = new Verification<Bytestream, Bytestream>(){

            @Override
            public void verify(Bytestream request, Bytestream response) {
                Assert.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assert.assertEquals((long)2L, (long)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[0];
                Assert.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        };
        this.createResponses(streamHostUsedVerification2);
        outputStream = byteStreamManager.establishSession(this.targetJID, this.sessionID).getOutputStream();
        inputStream = socks5Proxy.getSocket(digest).getInputStream();
        outputStream.write(data);
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        this.protocol.verifyAll();
    }

    @Test
    public void shouldNotPrioritizeSocks5ProxyIfPrioritizationDisabled() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)false);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        byteStreamManager.setProxyPrioritizationEnabled(false);
        Assert.assertFalse((boolean)byteStreamManager.isProxyPrioritizationEnabled());
        Verification<Bytestream, Bytestream> streamHostUsedVerification = new Verification<Bytestream, Bytestream>(){

            @Override
            public void verify(Bytestream request, Bytestream response) {
                Assert.assertEquals((Object)response.getSessionID(), (Object)request.getSessionID());
                Assert.assertEquals((long)2L, (long)request.getStreamHosts().size());
                Bytestream.StreamHost streamHost = (Bytestream.StreamHost)request.getStreamHosts().toArray()[1];
                Assert.assertEquals((Object)response.getUsedHost().getJID(), (Object)streamHost.getJID());
            }
        };
        this.createResponses(streamHostUsedVerification);
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(7778);
        socks5Proxy.start();
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        OutputStream outputStream = byteStreamManager.establishSession(this.targetJID, this.sessionID).getOutputStream();
        InputStream inputStream = socks5Proxy.getSocket(digest).getInputStream();
        byte[] data = new byte[]{1, 2, 3};
        outputStream.write(data);
        byte[] result = new byte[3];
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        this.protocol.verifyAll();
        this.createResponses(streamHostUsedVerification);
        outputStream = byteStreamManager.establishSession(this.targetJID, this.sessionID).getOutputStream();
        inputStream = socks5Proxy.getSocket(digest).getInputStream();
        outputStream.write(data);
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        this.protocol.verifyAll();
        byteStreamManager.setProxyPrioritizationEnabled(true);
    }

    private void createResponses(Verification<Bytestream, Bytestream> streamHostUsedVerification) {
        DiscoverInfo discoverInfo = Socks5PacketUtils.createDiscoverInfo(this.targetJID, this.initiatorJID);
        discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
        this.protocol.addResponse((Packet)discoverInfo, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverItems discoverItems = Socks5PacketUtils.createDiscoverItems(this.xmppServer, this.initiatorJID);
        discoverItems.addItem(new DiscoverItems.Item("proxy2.xmpp-server"));
        discoverItems.addItem(new DiscoverItems.Item(this.proxyJID));
        this.protocol.addResponse((Packet)discoverItems, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo1 = Socks5PacketUtils.createDiscoverInfo("proxy2.xmpp-server", this.initiatorJID);
        DiscoverInfo.Identity identity1 = new DiscoverInfo.Identity("proxy", "proxy2.xmpp-server", "bytestreams");
        proxyInfo1.addIdentity(identity1);
        this.protocol.addResponse((Packet)proxyInfo1, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        DiscoverInfo proxyInfo2 = Socks5PacketUtils.createDiscoverInfo(this.proxyJID, this.initiatorJID);
        DiscoverInfo.Identity identity2 = new DiscoverInfo.Identity("proxy", this.proxyJID, "bytestreams");
        proxyInfo2.addIdentity(identity2);
        this.protocol.addResponse((Packet)proxyInfo2, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostInfo1 = Socks5PacketUtils.createBytestreamResponse("proxy2.xmpp-server", this.initiatorJID);
        streamHostInfo1.addStreamHost("proxy2.xmpp-server", this.proxyAddress, 7778);
        this.protocol.addResponse((Packet)streamHostInfo1, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostInfo2 = Socks5PacketUtils.createBytestreamResponse(this.proxyJID, this.initiatorJID);
        streamHostInfo2.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
        this.protocol.addResponse((Packet)streamHostInfo2, Verification.correspondingSenderReceiver, Verification.requestTypeGET);
        Bytestream streamHostUsedPacket = Socks5PacketUtils.createBytestreamResponse(this.targetJID, this.initiatorJID);
        streamHostUsedPacket.setSessionID(this.sessionID);
        streamHostUsedPacket.setUsedHost(this.proxyJID);
        this.protocol.addResponse((Packet)streamHostUsedPacket, streamHostUsedVerification, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        IQ activationResponse = Socks5PacketUtils.createActivationConfirmation(this.proxyJID, this.initiatorJID);
        this.protocol.addResponse((Packet)activationResponse, new Verification<Bytestream, IQ>(){

            @Override
            public void verify(Bytestream request, IQ response) {
                Assert.assertEquals((Object)Socks5ByteStreamManagerTest.this.targetJID, (Object)request.getToActivate().getTarget());
            }
        }, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
    }

    @After
    public void cleanUp() {
        Socks5TestProxy.stopProxy();
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)true);
    }
}

