/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.stringencoder.Base32;
import org.jivesoftware.smack.util.stringencoder.StringEncoder;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.cache.SimpleDirectoryPersistentCache;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EntityCapsManagerTest
extends InitExtensions {
    @Before
    public void initSmackTestSuite() {
        SmackTestSuite.init();
    }

    @Test
    public void testComplexGenerationExample() {
        DiscoverInfo di = EntityCapsManagerTest.createComplexSamplePacket();
        String ver = EntityCapsManager.generateVerificationString((DiscoverInfo)di, (String)"sha-1");
        Assert.assertEquals((Object)"q07IKJEyjvHSyhy//CH0CxmKi8w=", (Object)ver);
    }

    @Test
    public void testSimpleDirectoryCacheBase32() throws IOException {
        EntityCapsManager.persistentCache = null;
        this.testSimpleDirectoryCache(Base32.getStringEncoder());
    }

    @Test
    public void testVerificationDuplicateFeatures() {
        DiscoverInfo di = EntityCapsManagerTest.createMalformedDiscoverInfo();
        Assert.assertTrue((boolean)di.containsDuplicateFeatures());
    }

    @Test
    public void testVerificationDuplicateIdentities() {
        DiscoverInfo di = EntityCapsManagerTest.createMalformedDiscoverInfo();
        Assert.assertTrue((boolean)di.containsDuplicateIdentities());
    }

    private void testSimpleDirectoryCache(StringEncoder stringEncoder) throws IOException {
        SimpleDirectoryPersistentCache cache = new SimpleDirectoryPersistentCache(EntityCapsManagerTest.createTempDirectory());
        EntityCapsManager.setPersistentCache((EntityCapsPersistentCache)cache);
        DiscoverInfo di = EntityCapsManagerTest.createComplexSamplePacket();
        String nodeVer = di.getNode() + "#" + EntityCapsManager.generateVerificationString((DiscoverInfo)di, (String)"sha-1");
        EntityCapsManager.addDiscoverInfoByNode((String)nodeVer, (DiscoverInfo)di);
        EntityCapsManager.clearMemoryCache();
        DiscoverInfo restored_di = EntityCapsManager.getDiscoveryInfoByNodeVer((String)nodeVer);
        Assert.assertNotNull((Object)restored_di);
        Assert.assertEquals((Object)di.toXML().toString(), (Object)restored_di.toXML().toString());
    }

    private static DiscoverInfo createComplexSamplePacket() {
        DiscoverInfo di = new DiscoverInfo();
        di.setFrom("benvolio@capulet.lit/230193");
        di.setPacketID("disco1");
        di.setTo("juliet@capulet.lit/chamber");
        di.setType(IQ.Type.result);
        LinkedList<DiscoverInfo.Identity> identities = new LinkedList<DiscoverInfo.Identity>();
        DiscoverInfo.Identity i = new DiscoverInfo.Identity("client", "pc", "Psi 0.11", "en");
        identities.add(i);
        i = new DiscoverInfo.Identity("client", "pc", "\u03a8 0.11", "el");
        identities.add(i);
        di.addIdentities(identities);
        di.addFeature("http://jabber.org/protocol/disco#items");
        di.addFeature("http://jabber.org/protocol/caps");
        di.addFeature("http://jabber.org/protocol/muc");
        di.addFeature("http://jabber.org/protocol/disco#info");
        DataForm df = new DataForm("result");
        FormField ff = new FormField("os");
        ff.addValue("Mac");
        df.addField(ff);
        ff = new FormField("FORM_TYPE");
        ff.setType("hidden");
        ff.addValue("urn:xmpp:dataforms:softwareinfo");
        df.addField(ff);
        ff = new FormField("ip_version");
        ff.addValue("ipv4");
        ff.addValue("ipv6");
        df.addField(ff);
        ff = new FormField("os_version");
        ff.addValue("10.5.1");
        df.addField(ff);
        ff = new FormField("software");
        ff.addValue("Psi");
        df.addField(ff);
        ff = new FormField("software_version");
        ff.addValue("0.11");
        df.addField(ff);
        di.addExtension((PacketExtension)df);
        return di;
    }

    private static DiscoverInfo createMalformedDiscoverInfo() {
        DiscoverInfo di = new DiscoverInfo();
        di.setFrom("benvolio@capulet.lit/230193");
        di.setPacketID("disco1");
        di.setTo(")juliet@capulet.lit/chamber");
        di.setType(IQ.Type.result);
        LinkedList<DiscoverInfo.Identity> identities = new LinkedList<DiscoverInfo.Identity>();
        DiscoverInfo.Identity i = new DiscoverInfo.Identity("client", "pc", "Psi 0.11", "en");
        identities.add(i);
        i = new DiscoverInfo.Identity("client", "pc", "\u03a8 0.11", "el");
        identities.add(i);
        di.addIdentities(identities);
        i = new DiscoverInfo.Identity("client", "pc", "\u03a8 0.11", "el");
        identities.add(i);
        di.addIdentities(identities);
        di.addFeature("http://jabber.org/protocol/disco#items");
        di.addFeature("http://jabber.org/protocol/caps");
        di.addFeature("http://jabber.org/protocol/muc");
        di.addFeature("http://jabber.org/protocol/disco#info");
        di.addFeature("http://jabber.org/protocol/disco#info");
        DataForm df = new DataForm("result");
        FormField ff = new FormField("os");
        ff.addValue("Mac");
        df.addField(ff);
        ff = new FormField("FORM_TYPE");
        ff.setType("hidden");
        ff.addValue("urn:xmpp:dataforms:softwareinfo");
        df.addField(ff);
        ff = new FormField("ip_version");
        ff.addValue("ipv4");
        ff.addValue("ipv6");
        df.addField(ff);
        ff = new FormField("os_version");
        ff.addValue("10.5.1");
        df.addField(ff);
        ff = new FormField("software");
        ff.addValue("Psi");
        df.addField(ff);
        ff = new FormField("software_version");
        ff.addValue("0.11");
        df.addField(ff);
        di.addExtension((PacketExtension)df);
        df = new DataForm("result");
        ff = new FormField("FORM_TYPE");
        ff.setType("hidden");
        ff.addValue("urn:xmpp:dataforms:softwareinfo");
        df.addField(ff);
        ff = new FormField("software");
        ff.addValue("smack");
        df.addField(ff);
        di.addExtension((PacketExtension)df);
        return di;
    }

    public static File createTempDirectory() throws IOException {
        File tmp = File.createTempFile("entity", "caps");
        tmp.delete();
        tmp.mkdir();
        return tmp;
    }
}

