/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.forward;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.forward.Forwarded;
import org.jivesoftware.smackx.forward.provider.ForwardedProvider;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;

public class ForwardedTest {
    private static Properties outputProperties = new Properties();

    @Test
    public void forwardedTest() throws Exception {
        String control = XMLBuilder.create((String)"forwarded").a("xmlns", "urn:xmpp:forwarded:0").e("message").a("from", "romeo@montague.com").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Forwarded fwd = (Forwarded)new ForwardedProvider().parse(parser);
        Assert.assertEquals(null, (Object)fwd.getDelayInformation());
        Assert.assertEquals((Object)"romeo@montague.com", (Object)fwd.getForwardedPacket().getFrom());
        Assert.assertEquals((long)3L, (long)parser.getEventType());
        Assert.assertEquals((Object)"forwarded", (Object)parser.getName());
    }

    @Test(expected=Exception.class)
    public void forwardedEmptyTest() throws Exception {
        String control = XMLBuilder.create((String)"forwarded").a("xmlns", "urn:xmpp:forwarded:0").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        new ForwardedProvider().parse(parser);
    }

    static {
        outputProperties.put("omit-xml-declaration", "yes");
    }
}

