/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.pubsub.ChildrenAssociationPolicy;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.FormType;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.junit.Assert;
import org.junit.Test;

public class ConfigureFormTest {
    @Test
    public void checkChildrenAssocPolicy() {
        ConfigureForm form = new ConfigureForm(FormType.submit);
        form.setChildrenAssociationPolicy(ChildrenAssociationPolicy.owners);
        Assert.assertEquals((Object)ChildrenAssociationPolicy.owners, (Object)form.getChildrenAssociationPolicy());
    }

    @Test
    public void getConfigFormWithInsufficientPriviliges() throws XMPPException, SmackException {
        ThreadedDummyConnection con = new ThreadedDummyConnection();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con);
        DiscoverInfo info = new DiscoverInfo();
        DiscoverInfo.Identity ident = new DiscoverInfo.Identity("pubsub", null, "leaf");
        info.addIdentity(ident);
        con.addIQReply((IQ)info);
        Node node = mgr.getNode("princely_musings");
        PubSub errorIq = new PubSub();
        XMPPError error = new XMPPError(XMPPError.Condition.forbidden);
        errorIq.setError(error);
        con.addIQReply((IQ)errorIq);
        try {
            node.getNodeConfiguration();
        }
        catch (XMPPException.XMPPErrorException e) {
            Assert.assertEquals((Object)XMPPError.Type.AUTH, (Object)e.getXMPPError().getType());
        }
    }

    @Test(expected=SmackException.class)
    public void getConfigFormWithTimeout() throws XMPPException, SmackException {
        ThreadedDummyConnection con = new ThreadedDummyConnection();
        PubSubManager mgr = new PubSubManager((XMPPConnection)con);
        DiscoverInfo info = new DiscoverInfo();
        DiscoverInfo.Identity ident = new DiscoverInfo.Identity("pubsub", null, "leaf");
        info.addIdentity(ident);
        con.addIQReply((IQ)info);
        Node node = mgr.getNode("princely_musings");
        SmackConfiguration.setDefaultPacketReplyTimeout((int)100);
        con.setTimeout();
        node.getNodeConfiguration();
    }
}

