/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.packet;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jivesoftware.smackx.xdata.provider.DataFormProvider;
import org.jivesoftware.smackx.xdatalayout.packet.DataLayout;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DataFormTest {
    private static final String TEST_OUTPUT_1 = "<x xmlns='jabber:x:data' type='SUBMIT'><instructions>InstructionTest1</instructions><field var='testField1'></field></x>";
    private static final String TEST_OUTPUT_2 = "<x xmlns='jabber:x:data' type='SUBMIT'><instructions>InstructionTest1</instructions><field var='testField1'></field><page xmlns='http://jabber.org/protocol/xdata-layout' label='Label'><fieldref var='testField1'/><section label='section Label'><text>SectionText</text></section><text>PageText</text></page></x>";
    private static Logger logger = Logger.getLogger(DataFormTest.class.getName());

    @Test
    public void test() throws XmlPullParserException, IOException, SmackException {
        DataForm df = new DataForm("SUBMIT");
        String instruction = "InstructionTest1";
        df.addInstruction(instruction);
        FormField field = new FormField("testField1");
        df.addField(field);
        Assert.assertNotNull((Object)df.toXML());
        String output = df.toXML().toString();
        logger.finest(output);
        Assert.assertEquals((Object)TEST_OUTPUT_1, (Object)output);
        DataFormProvider pr = new DataFormProvider();
        XmlPullParser parser = this.getParser(output);
        df = (DataForm)pr.parse(parser);
        Assert.assertNotNull((Object)df);
        Assert.assertNotNull((Object)df.getFields());
        Assert.assertEquals((long)1L, (long)df.getFields().size());
        Assert.assertEquals((long)1L, (long)df.getInstructions().size());
        Assert.assertNotNull((Object)df.toXML());
        output = df.toXML().toString();
        logger.finest(output);
        Assert.assertEquals((Object)TEST_OUTPUT_1, (Object)output);
    }

    @Test
    public void testLayout() throws XmlPullParserException, IOException, SmackException {
        DataForm df = new DataForm("SUBMIT");
        String instruction = "InstructionTest1";
        df.addInstruction(instruction);
        FormField field = new FormField("testField1");
        df.addField(field);
        DataLayout layout = new DataLayout("Label");
        DataLayout.Fieldref reffield = new DataLayout.Fieldref("testField1");
        layout.getPageLayout().add(reffield);
        DataLayout.Section section = new DataLayout.Section("section Label");
        section.getSectionLayout().add(new DataLayout.Text("SectionText"));
        layout.getPageLayout().add(section);
        layout.getPageLayout().add(new DataLayout.Text("PageText"));
        df.addExtensionElement((Element)layout);
        Assert.assertNotNull((Object)df.toXML());
        String output = df.toXML().toString();
        logger.finest(output);
        Assert.assertEquals((Object)TEST_OUTPUT_2, (Object)output);
        DataFormProvider pr = new DataFormProvider();
        XmlPullParser parser = this.getParser(output);
        df = (DataForm)pr.parse(parser);
        Assert.assertNotNull((Object)df);
        Assert.assertNotNull((Object)df.getExtensionElements());
        Assert.assertEquals((long)1L, (long)df.getExtensionElements().size());
        Element element = (Element)df.getExtensionElements().get(0);
        Assert.assertNotNull((Object)element);
        layout = (DataLayout)element;
        Assert.assertEquals((long)3L, (long)layout.getPageLayout().size());
        Assert.assertNotNull((Object)df.toXML());
        output = df.toXML().toString();
        logger.finest(output);
        Assert.assertEquals((Object)TEST_OUTPUT_2, (Object)output);
    }

    private XmlPullParser getParser(String output) throws XmlPullParserException, IOException {
        logger.finest("getParser");
        XmlPullParser parser = PacketParserUtils.newXmppParser();
        parser.setInput((Reader)new StringReader(output));
        parser.next();
        return parser;
    }
}

