/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ReportedData {
    private List<Column> columns = new ArrayList<Column>();
    private List<Row> rows = new ArrayList<Row>();
    private String title = "";

    public static ReportedData getReportedDataFrom(Packet packet) {
        DataForm dataForm = DataForm.from(packet);
        if (dataForm != null && dataForm.getReportedData() != null) {
            return new ReportedData(dataForm);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        for (FormField field : dataForm.getReportedData().getFields()) {
            this.columns.add(new Column(field.getLabel(), field.getVariable(), field.getType()));
        }
        for (DataForm.Item item : dataForm.getItems()) {
            ArrayList<Field> fieldList = new ArrayList<Field>(this.columns.size());
            for (FormField field : item.getFields()) {
                ArrayList<String> values = new ArrayList<String>();
                for (String value : field.getValues()) {
                    values.add(value);
                }
                fieldList.add(new Field(field.getVariable(), values));
            }
            this.rows.add(new Row(fieldList));
        }
        this.title = dataForm.getTitle();
    }

    public ReportedData() {
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public List<Row> getRows() {
        return Collections.unmodifiableList(new ArrayList<Row>(this.rows));
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(new ArrayList<Column>(this.columns));
    }

    public String getTitle() {
        return this.title;
    }

    public static class Field {
        private String variable;
        private List<String> values;

        public Field(String variable, List<String> values) {
            this.variable = variable;
            this.values = values;
        }

        public String getVariable() {
            return this.variable;
        }

        public List<String> getValues() {
            return Collections.unmodifiableList(this.values);
        }
    }

    public static class Row {
        private List<Field> fields = new ArrayList<Field>();

        public Row(List<Field> fields) {
            this.fields = fields;
        }

        public List<String> getValues(String variable) {
            for (Field field : this.getFields()) {
                if (!variable.equalsIgnoreCase(field.getVariable())) continue;
                return field.getValues();
            }
            return null;
        }

        private List<Field> getFields() {
            return Collections.unmodifiableList(new ArrayList<Field>(this.fields));
        }
    }

    public static class Column {
        private final String label;
        private final String variable;
        private final FormField.Type type;

        public Column(String label, String variable, FormField.Type type) {
            this.label = label;
            this.variable = variable;
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public FormField.Type getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

