/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.packet;

import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdatavalidation.ValidationConsistencyException;

public abstract class ValidateElement
implements PacketExtension {
    public static final String DATATYPE_XS_STRING = "xs:string";
    public static final String ELEMENT = "validate";
    public static final String NAMESPACE = "http://jabber.org/protocol/xdata-validate";
    private final String datatype;
    private ListRange listRange;

    private ValidateElement(String datatype) {
        this.datatype = StringUtils.isNotEmpty((CharSequence)datatype) ? datatype : null;
    }

    public String getDatatype() {
        return this.datatype != null ? this.datatype : DATATYPE_XS_STRING;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder((PacketExtension)this);
        buf.optAttribute("datatype", this.datatype);
        buf.rightAngleBracket();
        this.appendXML(buf);
        buf.optAppend((Element)this.getListRange());
        buf.closeElement((NamedElement)this);
        return buf;
    }

    protected abstract void appendXML(XmlStringBuilder var1);

    public void setListRange(ListRange listRange) {
        this.listRange = listRange;
    }

    public ListRange getListRange() {
        return this.listRange;
    }

    public abstract void checkConsistency(FormField var1);

    protected void checkListRangeConsistency(FormField formField) {
        ListRange listRange = this.getListRange();
        if (listRange == null) {
            return;
        }
        Long max = listRange.getMax();
        Long min = listRange.getMin();
        if ((max != null || min != null) && formField.getType() != FormField.Type.list_multi) {
            throw new ValidationConsistencyException("Field type is not of type 'list-multi' while a 'list-range' is defined.");
        }
    }

    protected void checkNonMultiConsistency(FormField formField, String method) {
        this.checkListRangeConsistency(formField);
        if (formField.getType() != null) {
            switch (formField.getType()) {
                case hidden: 
                case jid_multi: 
                case list_multi: 
                case text_multi: {
                    throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{formField.getType(), method}));
                }
            }
        }
    }

    public static class ListRange
    implements NamedElement {
        public static final String ELEMENT = "list-range";
        private final Long min;
        private final Long max;

        public ListRange(Long min, Long max) {
            if (min != null && min < 0L) {
                throw new IllegalArgumentException("min must not be negative");
            }
            if (max != null && max < 0L) {
                throw new IllegalArgumentException("max must not be negative");
            }
            if (max == null && min == null) {
                throw new IllegalArgumentException("Either min or max must be given");
            }
            this.min = min;
            this.max = max;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder buf = new XmlStringBuilder((NamedElement)this);
            buf.optLongAttribute("min", this.getMin());
            buf.optLongAttribute("max", this.getMax());
            buf.closeEmptyElement();
            return buf;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public Long getMin() {
            return this.min;
        }

        public Long getMax() {
            return this.max;
        }
    }

    public static class RegexValidateElement
    extends ValidateElement {
        public static final String METHOD = "regex";
        private final String regex;

        public RegexValidateElement(String dataType, String regex) {
            super(dataType);
            this.regex = regex;
        }

        public String getRegex() {
            return this.regex;
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.element(METHOD, this.getRegex());
        }

        @Override
        public void checkConsistency(FormField formField) {
            this.checkNonMultiConsistency(formField, METHOD);
        }
    }

    public static class RangeValidateElement
    extends ValidateElement {
        public static final String METHOD = "range";
        private final String min;
        private final String max;

        public RangeValidateElement(String dataType, String min, String max) {
            super(dataType);
            this.min = min;
            this.max = max;
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.halfOpenElement(METHOD);
            buf.optAttribute("min", this.getMin());
            buf.optAttribute("max", this.getMax());
            buf.closeEmptyElement();
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        @Override
        public void checkConsistency(FormField formField) {
            this.checkNonMultiConsistency(formField, METHOD);
            if (this.getDatatype().equals(ValidateElement.DATATYPE_XS_STRING)) {
                throw new ValidationConsistencyException(String.format("Field data type '%1$s' is not consistent with validation method '%2$s'.", this.getDatatype(), METHOD));
            }
        }
    }

    public static class OpenValidateElement
    extends ValidateElement {
        public static final String METHOD = "open";

        public OpenValidateElement(String dataType) {
            super(dataType);
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.emptyElement(METHOD);
        }

        @Override
        public void checkConsistency(FormField formField) {
            this.checkListRangeConsistency(formField);
            if (formField.getType() != null) {
                switch (formField.getType()) {
                    case hidden: {
                        throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{formField.getType(), METHOD}));
                    }
                }
            }
        }
    }

    public static class BasicValidateElement
    extends ValidateElement {
        public static final String METHOD = "basic";

        public BasicValidateElement(String dataType) {
            super(dataType);
        }

        @Override
        protected void appendXML(XmlStringBuilder buf) {
            buf.emptyElement(METHOD);
        }

        @Override
        public void checkConsistency(FormField formField) {
            this.checkListRangeConsistency(formField);
            if (formField.getType() != null) {
                switch (formField.getType()) {
                    case hidden: 
                    case jid_multi: 
                    case jid_single: {
                        throw new ValidationConsistencyException(String.format("Field type '%1$s' is not consistent with validation method '%2$s'.", new Object[]{formField.getType(), METHOD}));
                    }
                }
            }
        }
    }
}

