/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5PacketUtils;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5TestProxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Socks5ByteStreamRequestTest {
    String initiatorJID = "initiator@xmpp-server/Smack";
    String targetJID = "target@xmpp-server/Smack";
    String xmppServer = "xmpp-server";
    String proxyJID = "proxy.xmpp-server";
    String proxyAddress = "127.0.0.1";
    String sessionID = "session_id";
    Protocol protocol;
    XMPPConnection connection;

    @Before
    public void setup() throws XMPPException, SmackException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection(this.protocol, this.targetJID, this.xmppServer);
    }

    @Test
    public void shouldFailIfRequestHasNoStreamHosts() throws Exception {
        try {
            Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation(this.initiatorJID, this.targetJID, this.sessionID);
            Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
            Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
            byteStreamRequest.accept();
            Assert.fail((String)"exception should be thrown");
        }
        catch (XMPPException.XMPPErrorException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Could not establish socket with any provided host"));
        }
        Assert.assertEquals((long)1L, (long)this.protocol.getRequests().size());
        Packet targetResponse = this.protocol.getRequests().remove(0);
        Assert.assertTrue((boolean)IQ.class.isInstance(targetResponse));
        Assert.assertEquals((Object)this.initiatorJID, (Object)targetResponse.getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
        Assert.assertEquals((Object)XMPPError.Condition.item_not_found, (Object)((IQ)targetResponse).getError().getCondition());
    }

    @Test
    public void shouldFailIfRequestHasInvalidStreamHosts() throws Exception {
        try {
            Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation(this.initiatorJID, this.targetJID, this.sessionID);
            bytestreamInitialization.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
            Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
            Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
            byteStreamRequest.accept();
            Assert.fail((String)"exception should be thrown");
        }
        catch (XMPPException.XMPPErrorException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Could not establish socket with any provided host"));
        }
        Assert.assertEquals((long)1L, (long)this.protocol.getRequests().size());
        Packet targetResponse = this.protocol.getRequests().remove(0);
        Assert.assertTrue((boolean)IQ.class.isInstance(targetResponse));
        Assert.assertEquals((Object)this.initiatorJID, (Object)targetResponse.getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
        Assert.assertEquals((Object)XMPPError.Condition.item_not_found, (Object)((IQ)targetResponse).getError().getCondition());
    }

    @Test
    public void shouldBlacklistInvalidProxyAfter2Failures() throws Exception {
        Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation(this.initiatorJID, this.targetJID, this.sessionID);
        bytestreamInitialization.addStreamHost("invalid." + this.proxyJID, "127.0.0.2", 7778);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        for (int i = 0; i < 2; ++i) {
            try {
                Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
                byteStreamRequest.setTotalConnectTimeout(600);
                byteStreamRequest.setMinimumConnectTimeout(300);
                byteStreamRequest.accept();
                Assert.fail((String)"exception should be thrown");
            }
            catch (XMPPException.XMPPErrorException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Could not establish socket with any provided host"));
            }
            Assert.assertEquals((long)1L, (long)this.protocol.getRequests().size());
            Packet targetResponse = this.protocol.getRequests().remove(0);
            Assert.assertTrue((boolean)IQ.class.isInstance(targetResponse));
            Assert.assertEquals((Object)this.initiatorJID, (Object)targetResponse.getTo());
            Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
            Assert.assertEquals((Object)XMPPError.Condition.item_not_found, (Object)((IQ)targetResponse).getError().getCondition());
        }
        byte[] data = new byte[]{1, 2, 3};
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(7779);
        Assert.assertTrue((boolean)socks5Proxy.isRunning());
        bytestreamInitialization.addStreamHost(this.proxyJID, this.proxyAddress, 7779);
        Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
        byteStreamRequest.setTotalConnectTimeout(600);
        byteStreamRequest.setMinimumConnectTimeout(300);
        InputStream inputStream = byteStreamRequest.accept().getInputStream();
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        OutputStream outputStream = socks5Proxy.getSocket(digest).getOutputStream();
        outputStream.write(data);
        byte[] result = new byte[3];
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        Assert.assertEquals((long)1L, (long)this.protocol.getRequests().size());
        Packet targetResponse = this.protocol.getRequests().remove(0);
        Assert.assertEquals(Bytestream.class, targetResponse.getClass());
        Assert.assertEquals((Object)this.initiatorJID, (Object)targetResponse.getTo());
        Assert.assertEquals((Object)IQ.Type.result, (Object)((Bytestream)targetResponse).getType());
        Assert.assertEquals((Object)this.proxyJID, (Object)((Bytestream)targetResponse).getUsedHost().getJID());
    }

    @Test
    public void shouldNotBlacklistInvalidProxy() throws Exception {
        Socks5BytestreamRequest.setConnectFailureThreshold((int)0);
        Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation(this.initiatorJID, this.targetJID, this.sessionID);
        bytestreamInitialization.addStreamHost("invalid." + this.proxyJID, "127.0.0.2", 7778);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        for (int i = 0; i < 10; ++i) {
            try {
                Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
                byteStreamRequest.setTotalConnectTimeout(600);
                byteStreamRequest.setMinimumConnectTimeout(300);
                byteStreamRequest.accept();
                Assert.fail((String)"exception should be thrown");
            }
            catch (XMPPException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Could not establish socket with any provided host"));
            }
            Assert.assertEquals((long)1L, (long)this.protocol.getRequests().size());
            Packet targetResponse = this.protocol.getRequests().remove(0);
            Assert.assertTrue((boolean)IQ.class.isInstance(targetResponse));
            Assert.assertEquals((Object)this.initiatorJID, (Object)targetResponse.getTo());
            Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
            Assert.assertEquals((Object)XMPPError.Condition.item_not_found, (Object)((IQ)targetResponse).getError().getCondition());
        }
        Socks5BytestreamRequest.setConnectFailureThreshold((int)2);
    }

    @Test
    public void shouldNotTimeoutIfFirstSocks5ProxyDoesNotRespond() throws Exception {
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(7778);
        ServerSocket serverSocket = new ServerSocket(7779);
        Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation(this.initiatorJID, this.targetJID, this.sessionID);
        bytestreamInitialization.addStreamHost(this.proxyJID, this.proxyAddress, 7779);
        bytestreamInitialization.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
        byte[] data = new byte[]{1, 2, 3};
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
        byteStreamRequest.setTotalConnectTimeout(2000);
        byteStreamRequest.setMinimumConnectTimeout(1000);
        InputStream inputStream = byteStreamRequest.accept().getInputStream();
        Socket socket = serverSocket.accept();
        Assert.assertNotNull((Object)socket);
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        OutputStream outputStream = socks5Proxy.getSocket(digest).getOutputStream();
        outputStream.write(data);
        byte[] result = new byte[3];
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        Assert.assertEquals((long)1L, (long)this.protocol.getRequests().size());
        Packet targetResponse = this.protocol.getRequests().remove(0);
        Assert.assertEquals(Bytestream.class, targetResponse.getClass());
        Assert.assertEquals((Object)this.initiatorJID, (Object)targetResponse.getTo());
        Assert.assertEquals((Object)IQ.Type.result, (Object)((Bytestream)targetResponse).getType());
        Assert.assertEquals((Object)this.proxyJID, (Object)((Bytestream)targetResponse).getUsedHost().getJID());
        serverSocket.close();
    }

    @Test
    public void shouldAcceptSocks5BytestreamRequestAndReceiveData() throws Exception {
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(7778);
        Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation(this.initiatorJID, this.targetJID, this.sessionID);
        bytestreamInitialization.addStreamHost(this.proxyJID, this.proxyAddress, 7778);
        byte[] data = new byte[]{1, 2, 3};
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
        InputStream inputStream = byteStreamRequest.accept().getInputStream();
        String digest = Socks5Utils.createDigest((String)this.sessionID, (String)this.initiatorJID, (String)this.targetJID);
        OutputStream outputStream = socks5Proxy.getSocket(digest).getOutputStream();
        outputStream.write(data);
        byte[] result = new byte[3];
        inputStream.read(result);
        Assert.assertArrayEquals((byte[])data, (byte[])result);
        Assert.assertEquals((long)1L, (long)this.protocol.getRequests().size());
        Packet targetResponse = this.protocol.getRequests().remove(0);
        Assert.assertEquals(Bytestream.class, targetResponse.getClass());
        Assert.assertEquals((Object)this.initiatorJID, (Object)targetResponse.getTo());
        Assert.assertEquals((Object)IQ.Type.result, (Object)((Bytestream)targetResponse).getType());
        Assert.assertEquals((Object)this.proxyJID, (Object)((Bytestream)targetResponse).getUsedHost().getJID());
    }

    @After
    public void cleanUp() {
        Socks5TestProxy.stopProxy();
        Socks5Proxy.setLocalSocks5ProxyEnabled((boolean)true);
    }
}

