/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;

class InitiationListener
extends AbstractIqRequestHandler {
    private static final Logger LOGGER = Logger.getLogger(InitiationListener.class.getName());
    private final InBandBytestreamManager manager;
    private final ExecutorService initiationListenerExecutor;

    protected InitiationListener(InBandBytestreamManager manager) {
        super("open", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = manager;
        this.initiationListenerExecutor = Executors.newCachedThreadPool();
    }

    public IQ handleIQRequest(final IQ packet) {
        this.initiationListenerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InitiationListener.this.processRequest((Packet)packet);
                }
                catch (SmackException.NotConnectedException e) {
                    LOGGER.log(Level.WARNING, "proccessRequest", e);
                }
            }
        });
        return null;
    }

    private void processRequest(Packet packet) throws SmackException.NotConnectedException {
        Open ibbRequest = (Open)packet;
        if (ibbRequest.getBlockSize() > this.manager.getMaximumBlockSize()) {
            this.manager.replyResourceConstraintPacket(ibbRequest);
            return;
        }
        if (this.manager.getIgnoredBytestreamRequests().remove(ibbRequest.getSessionID())) {
            return;
        }
        InBandBytestreamRequest request = new InBandBytestreamRequest(this.manager, ibbRequest);
        BytestreamListener userListener = this.manager.getUserListener(ibbRequest.getFrom());
        if (userListener != null) {
            userListener.incomingBytestreamRequest(request);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener listener : this.manager.getAllRequestListeners()) {
                listener.incomingBytestreamRequest(request);
            }
        } else {
            this.manager.replyRejectPacket(ibbRequest);
        }
    }

    protected void shutdown() {
        this.initiationListenerExecutor.shutdownNow();
    }
}

