/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.ibb.CloseListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;

public class CloseListenerTest {
    String initiatorJID = "initiator@xmpp-server/Smack";
    String targetJID = "target@xmpp-server/Smack";

    @Test
    public void shouldReplyErrorIfSessionIsUnknown() throws Exception {
        XMPPConnection connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)connection);
        CloseListener closeListener = (CloseListener)Whitebox.getInternalState((Object)byteStreamManager, CloseListener.class);
        Close close = new Close("unknownSessionId");
        close.setFrom(this.initiatorJID);
        close.setTo(this.targetJID);
        closeListener.handleIQRequest((IQ)close);
        Thread.sleep(200L);
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)connection)).sendPacket((Stanza)argument.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.item_not_found, (Object)((IQ)argument.getValue()).getError().getCondition());
    }
}

