/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.receipts;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.test.util.WaitForPacketListener;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.receipts.DeliveryReceipt;
import org.jivesoftware.smackx.receipts.DeliveryReceiptManager;
import org.jivesoftware.smackx.receipts.DeliveryReceiptRequest;
import org.jivesoftware.smackx.receipts.ReceiptReceivedListener;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;

public class DeliveryReceiptTest
extends InitExtensions {
    private static Properties outputProperties = new Properties();

    @Test
    public void receiptTest() throws Exception {
        String control = XMLBuilder.create((String)"message").a("from", "romeo@montague.com").e("request").a("xmlns", "urn:xmpp:receipts").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        Message p = PacketParserUtils.parseMessage((XmlPullParser)parser);
        DeliveryReceiptRequest drr = (DeliveryReceiptRequest)p.getExtension("request", "urn:xmpp:receipts");
        Assert.assertNotNull((Object)drr);
        Assert.assertTrue((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Message)p));
        Message m = new Message("romeo@montague.com", Message.Type.normal);
        Assert.assertFalse((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Message)m));
        DeliveryReceiptRequest.addTo((Message)m);
        Assert.assertTrue((boolean)DeliveryReceiptManager.hasDeliveryReceiptRequest((Message)m));
    }

    @Test
    public void receiptManagerListenerTest() throws Exception {
        DummyConnection c = new DummyConnection();
        c.connect();
        DeliveryReceiptManager drm = DeliveryReceiptManager.getInstanceFor((XMPPConnection)c);
        TestReceiptReceivedListener rrl = new TestReceiptReceivedListener();
        drm.addReceiptReceivedListener((ReceiptReceivedListener)rrl);
        Message m = new Message("romeo@montague.com", Message.Type.normal);
        m.setFrom("julia@capulet.com");
        m.setStanzaId("reply-id");
        m.addExtension((PacketExtension)new DeliveryReceipt("original-test-id"));
        c.processPacket((Stanza)m);
        rrl.waitUntilInvocationOrTimeout();
    }

    @Test
    public void receiptManagerAutoReplyTest() throws Exception {
        DummyConnection c = new DummyConnection();
        c.connect();
        DeliveryReceiptManager drm = DeliveryReceiptManager.getInstanceFor((XMPPConnection)c);
        drm.setAutoReceiptMode(DeliveryReceiptManager.AutoReceiptMode.always);
        Assert.assertEquals((Object)DeliveryReceiptManager.AutoReceiptMode.always, (Object)drm.getAutoReceiptMode());
        Message m = new Message("julia@capulet.com", Message.Type.normal);
        m.setFrom("romeo@montague.com");
        m.setStanzaId("test-receipt-request");
        DeliveryReceiptRequest.addTo((Message)m);
        c.processPacket((Stanza)m);
        Stanza reply = (Stanza)c.getSentPacket();
        DeliveryReceipt r = DeliveryReceipt.from((Stanza)reply);
        Assert.assertEquals((Object)"romeo@montague.com", (Object)reply.getTo());
        Assert.assertEquals((Object)"test-receipt-request", (Object)r.getId());
    }

    static {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    private static class TestReceiptReceivedListener
    extends WaitForPacketListener
    implements ReceiptReceivedListener {
        private TestReceiptReceivedListener() {
        }

        public void onReceiptReceived(String fromJid, String toJid, String receiptId, Stanza receipt) {
            Assert.assertEquals((Object)"julia@capulet.com", (Object)fromJid);
            Assert.assertEquals((Object)"romeo@montague.com", (Object)toJid);
            Assert.assertEquals((Object)"original-test-id", (Object)receiptId);
            this.reportInvoked();
        }
    }
}

