/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.caps;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.caps.CapsVersionAndHash;
import org.jivesoftware.smackx.caps.cache.EntityCapsPersistentCache;
import org.jivesoftware.smackx.caps.packet.CapsExtension;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.util.cache.LruCache;

public class EntityCapsManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(EntityCapsManager.class.getName());
    public static final String NAMESPACE = "http://jabber.org/protocol/caps";
    public static final String ELEMENT = "c";
    private static final Map<String, MessageDigest> SUPPORTED_HASHES = new HashMap<String, MessageDigest>();
    private static final String DEFAULT_HASH = "SHA-1";
    private static String DEFAULT_ENTITY_NODE = "http://www.igniterealtime.org/projects/smack";
    protected static EntityCapsPersistentCache persistentCache;
    private static boolean autoEnableEntityCaps;
    private static Map<XMPPConnection, EntityCapsManager> instances;
    private static final PacketFilter PRESENCES_WITH_CAPS;
    private static final PacketFilter PRESENCES_WITHOUT_CAPS;
    private static final PacketFilter PRESENCES;
    private static final LruCache<String, DiscoverInfo> CAPS_CACHE;
    private static final LruCache<String, NodeVerHash> JID_TO_NODEVER_CACHE;
    private final Queue<CapsVersionAndHash> lastLocalCapsVersions = new ConcurrentLinkedQueue<CapsVersionAndHash>();
    private final ServiceDiscoveryManager sdm;
    private boolean entityCapsEnabled;
    private CapsVersionAndHash currentCapsVersion;
    private boolean presenceSend = false;
    private String entityNode = DEFAULT_ENTITY_NODE;

    public static void setDefaultEntityNode(String entityNode) {
        DEFAULT_ENTITY_NODE = entityNode;
    }

    public static void addDiscoverInfoByNode(String nodeVer, DiscoverInfo info) {
        CAPS_CACHE.put((Object)nodeVer, (Object)info);
        if (persistentCache != null) {
            persistentCache.addDiscoverInfoByNodePersistent(nodeVer, info);
        }
    }

    public static String getNodeVersionByJid(String jid) {
        NodeVerHash nvh = (NodeVerHash)JID_TO_NODEVER_CACHE.get((Object)jid);
        if (nvh != null) {
            return nvh.nodeVer;
        }
        return null;
    }

    public static NodeVerHash getNodeVerHashByJid(String jid) {
        return (NodeVerHash)JID_TO_NODEVER_CACHE.get((Object)jid);
    }

    public static DiscoverInfo getDiscoverInfoByUser(String user) {
        NodeVerHash nvh = (NodeVerHash)JID_TO_NODEVER_CACHE.get((Object)user);
        if (nvh == null) {
            return null;
        }
        return EntityCapsManager.getDiscoveryInfoByNodeVer(nvh.nodeVer);
    }

    public static DiscoverInfo getDiscoveryInfoByNodeVer(String nodeVer) {
        DiscoverInfo info = (DiscoverInfo)CAPS_CACHE.get((Object)nodeVer);
        if (info == null && (info = persistentCache.lookup(nodeVer)) != null) {
            CAPS_CACHE.put((Object)nodeVer, (Object)info);
        }
        if (info != null) {
            info = new DiscoverInfo(info);
        }
        return info;
    }

    public static void setPersistentCache(EntityCapsPersistentCache cache) {
        persistentCache = cache;
    }

    public static void setMaxsCacheSizes(int maxJidToNodeVerSize, int maxCapsCacheSize) {
        JID_TO_NODEVER_CACHE.setMaxCacheSize(maxJidToNodeVerSize);
        CAPS_CACHE.setMaxCacheSize(maxCapsCacheSize);
    }

    public static void clearMemoryCache() {
        JID_TO_NODEVER_CACHE.clear();
        CAPS_CACHE.clear();
    }

    private static void addCapsExtensionInfo(String from, CapsExtension capsExtension) {
        String capsExtensionHash = capsExtension.getHash();
        String hashInUppercase = capsExtensionHash.toUpperCase(Locale.US);
        if (!SUPPORTED_HASHES.containsKey(hashInUppercase)) {
            return;
        }
        String hash = capsExtensionHash.toLowerCase(Locale.US);
        String node = capsExtension.getNode();
        String ver = capsExtension.getVer();
        JID_TO_NODEVER_CACHE.put((Object)from, (Object)new NodeVerHash(node, ver, hash));
    }

    private EntityCapsManager(XMPPConnection connection) {
        super(connection);
        this.sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        instances.put(connection, this);
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void connected(XMPPConnection connection) {
                this.processCapsStreamFeatureIfAvailable(connection);
            }

            public void authenticated(XMPPConnection connection, boolean resumed) {
                this.processCapsStreamFeatureIfAvailable(connection);
                if (!resumed) {
                    EntityCapsManager.this.presenceSend = false;
                }
            }

            private void processCapsStreamFeatureIfAvailable(XMPPConnection connection) {
                CapsExtension capsExtension = (CapsExtension)connection.getFeature(EntityCapsManager.ELEMENT, EntityCapsManager.NAMESPACE);
                if (capsExtension == null) {
                    return;
                }
                String from = connection.getServiceName();
                EntityCapsManager.addCapsExtensionInfo(from, capsExtension);
            }
        });
        this.updateLocalEntityCaps();
        if (autoEnableEntityCaps) {
            this.enableEntityCaps();
        }
        connection.addAsyncPacketListener(new PacketListener(){

            public void processPacket(Stanza packet) {
                if (!EntityCapsManager.this.entityCapsEnabled()) {
                    return;
                }
                CapsExtension capsExtension = CapsExtension.from(packet);
                String from = packet.getFrom();
                EntityCapsManager.addCapsExtensionInfo(from, capsExtension);
            }
        }, PRESENCES_WITH_CAPS);
        connection.addAsyncPacketListener(new PacketListener(){

            public void processPacket(Stanza packet) {
                String from = packet.getFrom();
                JID_TO_NODEVER_CACHE.remove((Object)from);
            }
        }, PRESENCES_WITHOUT_CAPS);
        connection.addPacketSendingListener(new PacketListener(){

            public void processPacket(Stanza packet) {
                EntityCapsManager.this.presenceSend = true;
            }
        }, PRESENCES);
        PacketListener packetInterceptor = new PacketListener(){

            public void processPacket(Stanza packet) {
                if (!EntityCapsManager.this.entityCapsEnabled) {
                    return;
                }
                CapsVersionAndHash capsVersionAndHash = EntityCapsManager.this.getCapsVersion();
                CapsExtension caps = new CapsExtension(EntityCapsManager.this.entityNode, capsVersionAndHash.version, capsVersionAndHash.hash);
                packet.addExtension((PacketExtension)caps);
            }
        };
        connection.addPacketInterceptor(packetInterceptor, PRESENCES);
        this.sdm.setEntityCapsManager(this);
    }

    public static synchronized EntityCapsManager getInstanceFor(XMPPConnection connection) {
        if (SUPPORTED_HASHES.size() <= 0) {
            throw new IllegalStateException("No supported hashes for EntityCapsManager");
        }
        EntityCapsManager entityCapsManager = instances.get(connection);
        if (entityCapsManager == null) {
            entityCapsManager = new EntityCapsManager(connection);
        }
        return entityCapsManager;
    }

    public synchronized void enableEntityCaps() {
        this.sdm.addFeature(NAMESPACE);
        this.updateLocalEntityCaps();
        this.entityCapsEnabled = true;
    }

    public synchronized void disableEntityCaps() {
        this.entityCapsEnabled = false;
        this.sdm.removeFeature(NAMESPACE);
    }

    public boolean entityCapsEnabled() {
        return this.entityCapsEnabled;
    }

    public void setEntityNode(String entityNode) throws SmackException.NotConnectedException {
        this.entityNode = entityNode;
        this.updateLocalEntityCaps();
    }

    public void removeUserCapsNode(String user) {
        JID_TO_NODEVER_CACHE.remove((Object)user);
    }

    public CapsVersionAndHash getCapsVersion() {
        return this.currentCapsVersion;
    }

    public String getLocalNodeVer() {
        return this.entityNode + '#' + this.getCapsVersion();
    }

    public boolean areEntityCapsSupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.sdm.supportsFeature(jid, NAMESPACE);
    }

    public boolean areEntityCapsSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.areEntityCapsSupported(this.connection().getServiceName());
    }

    public void updateLocalEntityCaps() {
        XMPPConnection connection = this.connection();
        DiscoverInfo discoverInfo = new DiscoverInfo();
        discoverInfo.setType(IQ.Type.result);
        discoverInfo.setNode(this.getLocalNodeVer());
        if (connection != null) {
            discoverInfo.setFrom(connection.getUser());
        }
        this.sdm.addDiscoverInfoTo(discoverInfo);
        this.currentCapsVersion = EntityCapsManager.generateVerificationString(discoverInfo);
        EntityCapsManager.addDiscoverInfoByNode(this.entityNode + '#' + this.currentCapsVersion.version, discoverInfo);
        if (this.lastLocalCapsVersions.size() > 10) {
            CapsVersionAndHash oldCapsVersion = this.lastLocalCapsVersions.poll();
            this.sdm.removeNodeInformationProvider(this.entityNode + '#' + oldCapsVersion.version);
        }
        this.lastLocalCapsVersions.add(this.currentCapsVersion);
        if (connection != null) {
            JID_TO_NODEVER_CACHE.put((Object)connection.getUser(), (Object)new NodeVerHash(this.entityNode, this.currentCapsVersion));
        }
        final LinkedList<DiscoverInfo.Identity> identities = new LinkedList<DiscoverInfo.Identity>(ServiceDiscoveryManager.getInstanceFor(connection).getIdentities());
        this.sdm.setNodeInformationProvider(this.entityNode + '#' + this.currentCapsVersion, new AbstractNodeInformationProvider(){
            List<String> features;
            List<PacketExtension> packetExtensions;
            {
                this.features = EntityCapsManager.this.sdm.getFeatures();
                this.packetExtensions = EntityCapsManager.this.sdm.getExtendedInfoAsList();
            }

            @Override
            public List<String> getNodeFeatures() {
                return this.features;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return identities;
            }

            @Override
            public List<PacketExtension> getNodePacketExtensions() {
                return this.packetExtensions;
            }
        });
        if (connection != null && connection.isAuthenticated() && this.presenceSend) {
            Presence presence = new Presence(Presence.Type.available);
            try {
                connection.sendPacket((Stanza)presence);
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.log(Level.WARNING, "Could could not update presence with caps info", e);
            }
        }
    }

    public static boolean verifyDiscoverInfoVersion(String ver, String hash, DiscoverInfo info) {
        if (info.containsDuplicateIdentities()) {
            return false;
        }
        if (info.containsDuplicateFeatures()) {
            return false;
        }
        if (EntityCapsManager.verifyPacketExtensions(info)) {
            return false;
        }
        String calculatedVer = EntityCapsManager.generateVerificationString((DiscoverInfo)info, (String)hash).version;
        return ver.equals(calculatedVer);
    }

    protected static boolean verifyPacketExtensions(DiscoverInfo info) {
        LinkedList<FormField> foundFormTypes = new LinkedList<FormField>();
        for (PacketExtension pe : info.getExtensions()) {
            if (!pe.getNamespace().equals("jabber:x:data")) continue;
            DataForm df = (DataForm)pe;
            for (FormField f : df.getFields()) {
                if (!f.getVariable().equals("FORM_TYPE")) continue;
                for (FormField fft : foundFormTypes) {
                    if (!f.equals(fft)) continue;
                    return true;
                }
                foundFormTypes.add(f);
            }
        }
        return false;
    }

    protected static CapsVersionAndHash generateVerificationString(DiscoverInfo discoverInfo) {
        return EntityCapsManager.generateVerificationString(discoverInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CapsVersionAndHash generateVerificationString(DiscoverInfo discoverInfo, String hash) {
        byte[] digest;
        MessageDigest md;
        if (hash == null) {
            hash = DEFAULT_HASH;
        }
        if ((md = SUPPORTED_HASHES.get(hash.toUpperCase(Locale.US))) == null) {
            return null;
        }
        hash = hash.toLowerCase(Locale.US);
        DataForm extendedInfo = DataForm.from((Stanza)discoverInfo);
        StringBuilder sb = new StringBuilder();
        TreeSet<DiscoverInfo.Identity> sortedIdentities = new TreeSet<DiscoverInfo.Identity>();
        for (DiscoverInfo.Identity i : discoverInfo.getIdentities()) {
            sortedIdentities.add(i);
        }
        for (DiscoverInfo.Identity identity : sortedIdentities) {
            sb.append(identity.getCategory());
            sb.append("/");
            sb.append(identity.getType());
            sb.append("/");
            sb.append(identity.getLanguage() == null ? "" : identity.getLanguage());
            sb.append("/");
            sb.append(identity.getName() == null ? "" : identity.getName());
            sb.append("<");
        }
        TreeSet<String> features = new TreeSet<String>();
        for (DiscoverInfo.Feature feature : discoverInfo.getFeatures()) {
            features.add(feature.getVar());
        }
        for (String string : features) {
            sb.append(string);
            sb.append("<");
        }
        if (extendedInfo != null && extendedInfo.hasHiddenFormTypeField()) {
            DataForm i$ = extendedInfo;
            synchronized (i$) {
                TreeSet<FormField> treeSet = new TreeSet<FormField>(new Comparator<FormField>(){

                    @Override
                    public int compare(FormField f1, FormField f2) {
                        return f1.getVariable().compareTo(f2.getVariable());
                    }
                });
                FormField ft = null;
                for (FormField f : extendedInfo.getFields()) {
                    if (!f.getVariable().equals("FORM_TYPE")) {
                        treeSet.add(f);
                        continue;
                    }
                    ft = f;
                }
                if (ft != null) {
                    EntityCapsManager.formFieldValuesToCaps(ft.getValues(), sb);
                }
                for (FormField f : treeSet) {
                    sb.append(f.getVariable());
                    sb.append("<");
                    EntityCapsManager.formFieldValuesToCaps(f.getValues(), sb);
                }
            }
        }
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            digest = md.digest(sb.toString().getBytes());
        }
        String string = Base64.encodeToString((byte[])digest);
        return new CapsVersionAndHash(string, hash);
    }

    private static void formFieldValuesToCaps(List<String> i, StringBuilder sb) {
        TreeSet<String> fvs = new TreeSet<String>();
        for (String s : i) {
            fvs.add(s);
        }
        for (String fv : fvs) {
            sb.append(fv);
            sb.append("<");
        }
    }

    static {
        autoEnableEntityCaps = true;
        instances = new WeakHashMap<XMPPConnection, EntityCapsManager>();
        PRESENCES_WITH_CAPS = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new PacketExtensionFilter(ELEMENT, NAMESPACE)});
        PRESENCES_WITHOUT_CAPS = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Presence.class), new NotFilter((PacketFilter)new PacketExtensionFilter(ELEMENT, NAMESPACE))});
        PRESENCES = PacketTypeFilter.PRESENCE;
        CAPS_CACHE = new LruCache(1000);
        JID_TO_NODEVER_CACHE = new LruCache(10000);
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                EntityCapsManager.getInstanceFor(connection);
            }
        });
        try {
            MessageDigest sha1MessageDigest = MessageDigest.getInstance(DEFAULT_HASH);
            SUPPORTED_HASHES.put(DEFAULT_HASH, sha1MessageDigest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static class NodeVerHash {
        private String node;
        private String hash;
        private String ver;
        private String nodeVer;

        NodeVerHash(String node, CapsVersionAndHash capsVersionAndHash) {
            this(node, capsVersionAndHash.version, capsVersionAndHash.hash);
        }

        NodeVerHash(String node, String ver, String hash) {
            this.node = node;
            this.ver = ver;
            this.hash = hash;
            this.nodeVer = node + "#" + ver;
        }

        public String getNodeVer() {
            return this.nodeVer;
        }

        public String getNode() {
            return this.node;
        }

        public String getHash() {
            return this.hash;
        }

        public String getVer() {
            return this.ver;
        }
    }
}

