/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.ExpirationCache;

public class ServiceDiscoveryManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(ServiceDiscoveryManager.class.getName());
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private EntityCapsManager capsManager;
    private static Map<XMPPConnection, ServiceDiscoveryManager> instances = new WeakHashMap<XMPPConnection, ServiceDiscoveryManager>();
    private final Set<String> features = new HashSet<String>();
    private DataForm extendedInfo = null;
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();
    private Cache<String, List<String>> services = new ExpirationCache(25, 86400000L);

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection connection) {
        super(connection);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#items", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverItems discoverItems = (DiscoverItems)iqRequest;
                DiscoverItems response = new DiscoverItems();
                response.setType(IQ.Type.result);
                response.setTo(discoverItems.getFrom());
                response.setStanzaId(discoverItems.getStanzaId());
                response.setNode(discoverItems.getNode());
                NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                if (nodeInformationProvider != null) {
                    response.addItems(nodeInformationProvider.getNodeItems());
                    response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                } else if (discoverItems.getNode() != null) {
                    response.setType(IQ.Type.error);
                    response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                }
                return response;
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("query", "http://jabber.org/protocol/disco#info", IQ.Type.get, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                DiscoverInfo discoverInfo = (DiscoverInfo)iqRequest;
                DiscoverInfo response = new DiscoverInfo();
                response.setType(IQ.Type.result);
                response.setTo(discoverInfo.getFrom());
                response.setStanzaId(discoverInfo.getStanzaId());
                response.setNode(discoverInfo.getNode());
                if (discoverInfo.getNode() == null) {
                    ServiceDiscoveryManager.this.addDiscoverInfoTo(response);
                } else {
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                    if (nodeInformationProvider != null) {
                        response.addFeatures(nodeInformationProvider.getNodeFeatures());
                        response.addIdentities(nodeInformationProvider.getNodeIdentities());
                        response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                    } else {
                        response.setType(IQ.Type.error);
                        response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                    }
                }
                return response;
            }
        });
    }

    public String getIdentityName() {
        return this.identity.getName();
    }

    public void setIdentity(DiscoverInfo.Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity can not be null");
        }
        this.identity = identity;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identity.getType();
    }

    public void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> res = new HashSet<DiscoverInfo.Identity>(this.identities);
        res.add(defaultIdentity);
        return Collections.unmodifiableSet(res);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection connection) {
        ServiceDiscoveryManager sdm = instances.get(connection);
        if (sdm == null) {
            sdm = new ServiceDiscoveryManager(connection);
            instances.put(connection, sdm);
        }
        return sdm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoverInfoTo(DiscoverInfo response) {
        response.addIdentities(this.getIdentities());
        Set<String> set = this.features;
        synchronized (set) {
            for (String feature : this.getFeatures()) {
                response.addFeature(feature);
            }
            response.addExtension(this.extendedInfo);
        }
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFeatures() {
        Set<String> set = this.features;
        synchronized (set) {
            return new ArrayList<String>(this.features);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            if (!this.features.contains(feature)) {
                this.features.add(feature);
                this.renewEntityCapsVersion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.remove(feature);
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            return this.features.contains(feature);
        }
    }

    public void setExtendedInfo(DataForm info) {
        this.extendedInfo = info;
        this.renewEntityCapsVersion();
    }

    public DataForm getExtendedInfo() {
        return this.extendedInfo;
    }

    public List<PacketExtension> getExtendedInfoAsList() {
        ArrayList<DataForm> res = null;
        if (this.extendedInfo != null) {
            res = new ArrayList<DataForm>(1);
            res.add(this.extendedInfo);
        }
        return res;
    }

    public void removeExtendedInfo() {
        this.extendedInfo = null;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo discoverInfo(String entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (entityID == null) {
            return this.discoverInfo(null, null);
        }
        DiscoverInfo info = EntityCapsManager.getDiscoverInfoByUser(entityID);
        if (info != null) {
            return info;
        }
        EntityCapsManager.NodeVerHash nvh = EntityCapsManager.getNodeVerHashByJid(entityID);
        info = this.discoverInfo(entityID, nvh != null ? nvh.getNodeVer() : null);
        if (nvh != null && EntityCapsManager.verifyDiscoverInfoVersion(nvh.getVer(), nvh.getHash(), info)) {
            EntityCapsManager.addDiscoverInfoByNode(nvh.getNodeVer(), info);
        }
        return info;
    }

    public DiscoverInfo discoverInfo(String entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo disco = new DiscoverInfo();
        disco.setType(IQ.Type.get);
        disco.setTo(entityID);
        disco.setNode(node);
        Stanza result = this.connection().createPacketCollectorAndSend((IQ)disco).nextResultOrThrow();
        return (DiscoverInfo)result;
    }

    public DiscoverItems discoverItems(String entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(String entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.get);
        disco.setTo(entityID);
        disco.setNode(node);
        Stanza result = this.connection().createPacketCollectorAndSend((IQ)disco).nextResultOrThrow();
        return (DiscoverItems)result;
    }

    public boolean canPublishItems(String entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo info = this.discoverInfo(entityID);
        return ServiceDiscoveryManager.canPublishItems(info);
    }

    public static boolean canPublishItems(DiscoverInfo info) {
        return info.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(String entityID, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.publishItems(entityID, null, discoverItems);
    }

    public void publishItems(String entityID, String node, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        discoverItems.setType(IQ.Type.set);
        discoverItems.setTo(entityID);
        discoverItems.setNode(node);
        this.connection().createPacketCollectorAndSend((IQ)discoverItems).nextResultOrThrow();
    }

    public boolean serverSupportsFeature(String feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.supportsFeature(this.connection().getServiceName(), feature);
    }

    public boolean supportsFeature(String jid, String feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo result = this.discoverInfo(jid);
        return result.containsFeature(feature);
    }

    public List<String> findServices(String feature, boolean stopOnFirst, boolean useCache) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems items;
        DiscoverInfo info;
        LinkedList<String> serviceAddresses = null;
        String serviceName = this.connection().getServiceName();
        if (useCache && (serviceAddresses = (List)this.services.get((Object)feature)) != null) {
            return serviceAddresses;
        }
        serviceAddresses = new LinkedList();
        try {
            info = this.discoverInfo(serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could not discover information about service", e);
            return serviceAddresses;
        }
        if (info.containsFeature(feature)) {
            serviceAddresses.add(serviceName);
            if (stopOnFirst) {
                if (useCache) {
                    this.services.put((Object)feature, serviceAddresses);
                }
                return serviceAddresses;
            }
        }
        try {
            items = this.discoverItems(serviceName);
        }
        catch (XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could not discover items about service", e);
            return serviceAddresses;
        }
        for (DiscoverItems.Item item : items.getItems()) {
            try {
                info = this.discoverInfo(item.getEntityID());
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Exception while discovering info for feature " + feature + " of " + item.getEntityID() + " node: " + item.getNode(), e);
                continue;
            }
            if (!info.containsFeature(feature)) continue;
            serviceAddresses.add(item.getEntityID());
            if (!stopOnFirst) continue;
            break;
        }
        if (useCache) {
            this.services.put((Object)feature, serviceAddresses);
        }
        return serviceAddresses;
    }

    public void setEntityCapsManager(EntityCapsManager manager) {
        this.capsManager = manager;
    }

    private void renewEntityCapsVersion() {
        if (this.capsManager != null && this.capsManager.entityCapsEnabled()) {
            this.capsManager.updateLocalEntityCaps();
        }
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection);
            }
        });
    }
}

