/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;

public class MUCItem
implements NamedElement {
    public static final String ELEMENT = "item";
    private final MUCAffiliation affiliation;
    private final MUCRole role;
    private final String actor;
    private final String reason;
    private final String jid;
    private final String nick;

    public MUCItem(MUCAffiliation affiliation) {
        this(affiliation, null, null, null, null, null);
    }

    public MUCItem(MUCRole role) {
        this(null, role, null, null, null, null);
    }

    public MUCItem(MUCRole role, String nick) {
        this(null, role, null, null, null, nick);
    }

    public MUCItem(MUCAffiliation affiliation, String jid, String reason) {
        this(affiliation, null, null, reason, jid, null);
    }

    public MUCItem(MUCAffiliation affiliation, String jid) {
        this(affiliation, null, null, null, jid, null);
    }

    public MUCItem(MUCRole role, String nick, String reason) {
        this(null, role, null, reason, null, nick);
    }

    public MUCItem(MUCAffiliation affiliation, MUCRole role, String actor, String reason, String jid, String nick) {
        this.affiliation = affiliation;
        this.role = role;
        this.actor = actor;
        this.reason = reason;
        this.jid = jid;
        this.nick = nick;
    }

    public String getActor() {
        return this.actor;
    }

    public String getReason() {
        return this.reason;
    }

    public MUCAffiliation getAffiliation() {
        return this.affiliation;
    }

    public String getJid() {
        return this.jid;
    }

    public String getNick() {
        return this.nick;
    }

    public MUCRole getRole() {
        return this.role;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
        xml.optAttribute("affiliation", (Enum)this.getAffiliation());
        xml.optAttribute("jid", this.getJid());
        xml.optAttribute("nick", this.getNick());
        if (this.role != null && this.role != MUCRole.none) {
            xml.attribute("role", (Enum)this.getRole());
        }
        xml.rightAngleBracket();
        xml.optElement("reason", this.getReason());
        if (this.getActor() != null) {
            xml.halfOpenElement("actor").attribute("jid", this.getActor()).closeEmptyElement();
        }
        xml.closeElement(ELEMENT);
        return xml;
    }

    public String getElementName() {
        return ELEMENT;
    }
}

