/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation;

import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdatavalidation.ValidationConsistencyException;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.junit.Assert;
import org.junit.Test;

public class DataValidationHelperTest {
    @Test
    public void testCheckConsistencyFormFieldBasicValidateElement() {
        FormField field = new FormField("var");
        field.setType(FormField.Type.jid_single);
        ValidateElement.BasicValidateElement element = new ValidateElement.BasicValidateElement(null);
        try {
            element.checkConsistency(field);
            Assert.fail((String)"No correct check on consistency");
        }
        catch (ValidationConsistencyException e) {
            Assert.assertEquals((Object)"Field type 'jid-single' is not consistent with validation method 'basic'.", (Object)e.getMessage());
        }
        try {
            new ValidateElement.ListRange(Long.valueOf(-1L), Long.valueOf(1L));
            Assert.fail((String)"No correct check on consistency");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"unsigned 32-bit integers can't be negative", (Object)e.getMessage());
        }
        element.setListRange(new ValidateElement.ListRange(Long.valueOf(10L), Long.valueOf(100L)));
        try {
            element.checkConsistency(field);
            Assert.fail((String)"No correct check on consistency");
        }
        catch (ValidationConsistencyException e) {
            Assert.assertEquals((Object)"Field type is not of type 'list-multi' while a 'list-range' is defined.", (Object)e.getMessage());
        }
        field.setType(FormField.Type.list_multi);
        try {
            element.checkConsistency(field);
        }
        catch (ValidationConsistencyException e) {
            Assert.fail((String)"No correct check on consistency");
        }
    }

    @Test
    public void testCheckConsistencyFormFieldOpenValidateElement() {
        FormField field = new FormField("var");
        field.setType(FormField.Type.hidden);
        ValidateElement.OpenValidateElement element = new ValidateElement.OpenValidateElement(null);
        try {
            element.checkConsistency(field);
            Assert.fail((String)"No correct check on consistency");
        }
        catch (ValidationConsistencyException e) {
            Assert.assertEquals((Object)"Field type 'hidden' is not consistent with validation method 'open'.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckConsistencyFormFieldRangeValidateElement() {
        FormField field = new FormField("var");
        field.setType(FormField.Type.text_multi);
        ValidateElement.RangeValidateElement element = new ValidateElement.RangeValidateElement("xs:integer", null, "99");
        try {
            element.checkConsistency(field);
            Assert.fail((String)"No correct check on consistency");
        }
        catch (ValidationConsistencyException e) {
            Assert.assertEquals((Object)"Field type 'text-multi' is not consistent with validation method 'range'.", (Object)e.getMessage());
        }
    }

    @Test
    public void testCheckConsistencyFormFieldRegexValidateElement() {
        FormField field = new FormField("var");
        field.setType(FormField.Type.list_multi);
        ValidateElement.RegexValidateElement element = new ValidateElement.RegexValidateElement(null, ".*");
        try {
            element.checkConsistency(field);
            Assert.fail((String)"No correct check on consistency");
        }
        catch (ValidationConsistencyException e) {
            Assert.assertEquals((Object)"Field type 'list-multi' is not consistent with validation method 'regex'.", (Object)e.getMessage());
        }
    }
}

