/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.delay.provider;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.parsers.FactoryConfigurationError;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.delay.DelayInformationManager;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.jivesoftware.smackx.delay.provider.DelayInformationProvider;
import org.jivesoftware.smackx.delay.provider.LegacyDelayInformationProvider;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.util.XmppDateTime;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DelayInformationTest
extends InitExtensions {
    private static final Calendar calendar = new GregorianCalendar(2002, 8, 10, 23, 8, 25);
    private static Properties outputProperties = new Properties();

    @Test
    public void delayInformationTest() throws Exception {
        DelayInformationProvider p = new DelayInformationProvider();
        GregorianCalendar calendar = new GregorianCalendar(2002, 8, 10, 23, 8, 25);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = calendar.getTime();
        String control = XMLBuilder.create((String)"x").a("xmlns", "jabber:x:delay").a("from", "capulet.com").a("stamp", "2002-09-10T23:08:25Z").t("Offline Storage").asString(outputProperties);
        XmlPullParser parser = PacketParserUtils.getParserFor((String)control);
        DelayInformation delayInfo = (DelayInformation)p.parse(parser);
        Assert.assertEquals((Object)"capulet.com", (Object)delayInfo.getFrom());
        Assert.assertEquals((Object)date, (Object)delayInfo.getStamp());
        Assert.assertEquals((Object)"Offline Storage", (Object)delayInfo.getReason());
        Assert.assertEquals((long)3L, (long)parser.getEventType());
        Assert.assertEquals((Object)"x", (Object)parser.getName());
        control = XMLBuilder.create((String)"x").a("xmlns", "jabber:x:delay").a("from", "capulet.com").a("stamp", "2002-09-10T23:08:25Z").asString(outputProperties);
        parser = PacketParserUtils.getParserFor((String)control);
        delayInfo = (DelayInformation)p.parse(parser);
        Assert.assertEquals((Object)"capulet.com", (Object)delayInfo.getFrom());
        Assert.assertEquals((Object)date, (Object)delayInfo.getStamp());
        Assert.assertNull((Object)delayInfo.getReason());
        Assert.assertEquals((long)3L, (long)parser.getEventType());
        Assert.assertEquals((Object)"x", (Object)parser.getName());
    }

    @Test
    public void dateFormatsTest() throws Exception {
        DelayInformationProvider p = new DelayInformationProvider();
        String control = XMLBuilder.create((String)"delay").a("xmlns", "urn:xmpp:delay").a("from", "capulet.com").a("stamp", "2002-09-10T23:08:25.12Z").asString(outputProperties);
        DelayInformation delayInfo = (DelayInformation)p.parse(PacketParserUtils.getParserFor((String)control));
        GregorianCalendar cal = (GregorianCalendar)calendar.clone();
        cal.add(14, 120);
        Assert.assertEquals((Object)cal.getTime(), (Object)delayInfo.getStamp());
        control = XMLBuilder.create((String)"delay").a("xmlns", "urn:xmpp:delay").a("from", "capulet.com").a("stamp", "2002-09-10T23:08:25Z").asString(outputProperties);
        delayInfo = (DelayInformation)p.parse(PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)calendar.getTime(), (Object)delayInfo.getStamp());
        control = XMLBuilder.create((String)"delay").a("xmlns", "urn:xmpp:delay").a("from", "capulet.com").a("stamp", "2002-9-10T23:08:25Z").asString(outputProperties);
        delayInfo = (DelayInformation)p.parse(PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)calendar.getTime(), (Object)delayInfo.getStamp());
    }

    @Test
    public void legacyDateFormatsTest() throws FactoryConfigurationError, XmlPullParserException, IOException, Exception {
        LegacyDelayInformationProvider p = new LegacyDelayInformationProvider();
        String control = XMLBuilder.create((String)"x").a("xmlns", "jabber:x:delay").a("from", "capulet.com").a("stamp", "20020910T23:08:25").asString(outputProperties);
        DelayInformation delayInfo = (DelayInformation)p.parse(PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)calendar.getTime(), (Object)delayInfo.getStamp());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMd'T'HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        GregorianCalendar dateInPast = new GregorianCalendar();
        if (dateInPast.get(2) >= 10) {
            dateInPast.set(2, dateInPast.get(2) - 3);
        }
        dateInPast.add(5, -3);
        dateInPast.set(14, 0);
        control = XMLBuilder.create((String)"x").a("xmlns", "jabber:x:delay").a("from", "capulet.com").a("stamp", dateFormat.format(dateInPast.getTime())).asString(outputProperties);
        delayInfo = (DelayInformation)p.parse(PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)dateInPast.getTime(), (Object)delayInfo.getStamp());
        control = XMLBuilder.create((String)"x").a("xmlns", "jabber:x:delay").a("from", "capulet.com").a("stamp", "200868T09:16:20").asString(outputProperties);
        delayInfo = (DelayInformation)p.parse(PacketParserUtils.getParserFor((String)control));
        Date controlDate = XmppDateTime.parseDate((String)"2008-06-08T09:16:20.0Z");
        Assert.assertEquals((Object)controlDate, (Object)delayInfo.getStamp());
    }

    @Test
    public void validatePresenceWithDelayedDelivery() throws Exception {
        String stanza = "<presence from='mercutio@example.com' to='juliet@example.com'><delay xmlns='urn:xmpp:delay' stamp='2002-09-10T23:41:07Z'/></presence>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        DelayInformation delay = DelayInformationManager.getXep203DelayInformation((Stanza)presence);
        Assert.assertNotNull((Object)delay);
        Date date = XmppDateTime.parseDate((String)"2002-09-10T23:41:07Z");
        Assert.assertEquals((Object)date, (Object)delay.getStamp());
    }

    @Test
    public void parsePresenceWithInvalidLegacyDelayed() throws Exception {
        String stanza = "<presence from='mercutio@example.com' to='juliet@example.com'><x xmlns='jabber:x:delay'/></presence>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        DelayInformation delay = DelayInformationManager.getXep203DelayInformation((Stanza)presence);
        Assert.assertNull((Object)delay);
    }

    static {
        outputProperties.put("omit-xml-declaration", "yes");
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

