/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithSubjectFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ToFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iqregister.packet.Registration;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCNotJoinedException;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCAdmin;
import org.jivesoftware.smackx.muc.packet.MUCInitialPresence;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class MultiUserChat {
    private static final Logger LOGGER = Logger.getLogger(MultiUserChat.class.getName());
    private final XMPPConnection connection;
    private final String room;
    private final MultiUserChatManager multiUserChatManager;
    private final Map<String, Presence> occupantsMap = new ConcurrentHashMap<String, Presence>();
    private final Set<InvitationRejectionListener> invitationRejectionListeners = new CopyOnWriteArraySet<InvitationRejectionListener>();
    private final Set<SubjectUpdatedListener> subjectUpdatedListeners = new CopyOnWriteArraySet<SubjectUpdatedListener>();
    private final Set<UserStatusListener> userStatusListeners = new CopyOnWriteArraySet<UserStatusListener>();
    private final Set<ParticipantStatusListener> participantStatusListeners = new CopyOnWriteArraySet<ParticipantStatusListener>();
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Set<PresenceListener> presenceListeners = new CopyOnWriteArraySet<PresenceListener>();
    private final Set<PresenceListener> presenceInterceptors = new CopyOnWriteArraySet<PresenceListener>();
    private final StanzaFilter fromRoomFilter;
    private final StanzaFilter fromRoomGroupchatFilter;
    private final StanzaListener presenceInterceptor;
    private final StanzaListener messageListener;
    private final StanzaListener presenceListener;
    private final StanzaListener subjectListener;
    private final StanzaListener declinesListener;
    private String subject;
    private String nickname = null;
    private boolean joined = false;
    private PacketCollector messageCollector;

    MultiUserChat(XMPPConnection connection, String room, MultiUserChatManager multiUserChatManager) {
        this.connection = connection;
        this.room = room.toLowerCase(Locale.US);
        this.multiUserChatManager = multiUserChatManager;
        this.fromRoomFilter = FromMatchesFilter.create((String)room);
        this.fromRoomGroupchatFilter = new AndFilter(new StanzaFilter[]{this.fromRoomFilter, MessageTypeFilter.GROUPCHAT});
        this.messageListener = new StanzaListener(){

            public void processPacket(Stanza packet) throws SmackException.NotConnectedException {
                Message message = (Message)packet;
                for (MessageListener listener : MultiUserChat.this.messageListeners) {
                    listener.processMessage(message);
                }
            }
        };
        this.subjectListener = new StanzaListener(){

            public void processPacket(Stanza packet) {
                Message msg = (Message)packet;
                MultiUserChat.this.subject = msg.getSubject();
                for (SubjectUpdatedListener listener : MultiUserChat.this.subjectUpdatedListeners) {
                    listener.subjectUpdated(MultiUserChat.this.subject, msg.getFrom());
                }
            }
        };
        this.presenceListener = new StanzaListener(){

            public void processPacket(Stanza packet) {
                Presence presence = (Presence)packet;
                String from = presence.getFrom();
                String myRoomJID = MultiUserChat.this.room + "/" + MultiUserChat.this.nickname;
                boolean isUserStatusModification = presence.getFrom().equals(myRoomJID);
                switch (presence.getType()) {
                    case available: {
                        Presence oldPresence = MultiUserChat.this.occupantsMap.put(from, presence);
                        if (oldPresence != null) {
                            Object mucExtension = MUCUser.from(packet);
                            MUCAffiliation oldAffiliation = ((MUCUser)mucExtension).getItem().getAffiliation();
                            MUCRole oldRole = ((MUCUser)mucExtension).getItem().getRole();
                            mucExtension = MUCUser.from(packet);
                            MUCAffiliation newAffiliation = ((MUCUser)mucExtension).getItem().getAffiliation();
                            MUCRole newRole = ((MUCUser)mucExtension).getItem().getRole();
                            MultiUserChat.this.checkRoleModifications(oldRole, newRole, isUserStatusModification, from);
                            MultiUserChat.this.checkAffiliationModifications(oldAffiliation, newAffiliation, isUserStatusModification, from);
                            break;
                        }
                        if (isUserStatusModification) break;
                        for (ParticipantStatusListener listener : MultiUserChat.this.participantStatusListeners) {
                            listener.joined(from);
                        }
                        break;
                    }
                    case unavailable: {
                        MultiUserChat.this.occupantsMap.remove(from);
                        MUCUser mucUser = MUCUser.from(packet);
                        if (mucUser != null && mucUser.hasStatus()) {
                            MultiUserChat.this.checkPresenceCode(mucUser.getStatus(), presence.getFrom().equals(myRoomJID), mucUser, from);
                            break;
                        }
                        if (isUserStatusModification) break;
                        for (ParticipantStatusListener listener : MultiUserChat.this.participantStatusListeners) {
                            listener.left(from);
                        }
                        break;
                    }
                }
                for (PresenceListener listener : MultiUserChat.this.presenceListeners) {
                    listener.processPresence(presence);
                }
            }
        };
        this.declinesListener = new StanzaListener(){

            public void processPacket(Stanza packet) {
                MUCUser mucUser = MUCUser.from(packet);
                if (mucUser.getDecline() == null) {
                    return;
                }
                MultiUserChat.this.fireInvitationRejectionListeners(mucUser.getDecline().getFrom(), mucUser.getDecline().getReason());
            }
        };
        this.presenceInterceptor = new StanzaListener(){

            public void processPacket(Stanza packet) {
                Presence presence = (Presence)packet;
                for (PresenceListener interceptor : MultiUserChat.this.presenceInterceptors) {
                    interceptor.processPresence(presence);
                }
            }
        };
    }

    public String getRoom() {
        return this.room;
    }

    private Presence enter(String nickname, String password, DiscussionHistory history, long timeout) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        Presence presence;
        StringUtils.requireNotNullOrEmpty((CharSequence)nickname, (String)"Nickname must not be null or blank.");
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(this.room + "/" + nickname);
        MUCInitialPresence mucInitialPresence = new MUCInitialPresence();
        if (password != null) {
            mucInitialPresence.setPassword(password);
        }
        if (history != null) {
            mucInitialPresence.setHistory(history.getMUCHistory());
        }
        joinPresence.addExtension((ExtensionElement)mucInitialPresence);
        AndFilter responseFilter = new AndFilter(new StanzaFilter[]{FromMatchesFilter.createFull((String)(this.room + "/" + nickname)), new StanzaTypeFilter(Presence.class)});
        this.connection.addSyncStanzaListener(this.messageListener, this.fromRoomGroupchatFilter);
        this.connection.addSyncStanzaListener(this.presenceListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{this.fromRoomFilter, StanzaTypeFilter.PRESENCE}));
        this.connection.addSyncStanzaListener(this.subjectListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{this.fromRoomFilter, MessageWithSubjectFilter.INSTANCE}));
        this.connection.addSyncStanzaListener(this.declinesListener, (StanzaFilter)new AndFilter(new StanzaFilter[]{new StanzaExtensionFilter("x", "http://jabber.org/protocol/muc#user"), new NotFilter(MessageTypeFilter.ERROR)}));
        this.connection.addPacketInterceptor(this.presenceInterceptor, (StanzaFilter)new AndFilter(new StanzaFilter[]{new ToFilter(this.room), StanzaTypeFilter.PRESENCE}));
        this.messageCollector = this.connection.createPacketCollector(this.fromRoomGroupchatFilter);
        try {
            presence = (Presence)this.connection.createPacketCollectorAndSend((StanzaFilter)responseFilter, (Stanza)joinPresence).nextResultOrThrow(timeout);
        }
        catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
            this.removeConnectionCallbacks();
            throw e;
        }
        this.nickname = nickname;
        this.joined = true;
        this.multiUserChatManager.addJoinedRoom(this.room);
        return presence;
    }

    public synchronized void create(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException {
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        if (this.createOrJoin(nickname)) {
            return;
        }
        this.leave();
        throw new SmackException("Creation failed - Missing acknowledge of room creation.");
    }

    public synchronized boolean createOrJoin(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException {
        return this.createOrJoin(nickname, null, null, this.connection.getPacketReplyTimeout());
    }

    public synchronized boolean createOrJoin(String nickname, String password, DiscussionHistory history, long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException {
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        Presence presence = this.enter(nickname, password, history, timeout);
        MUCUser mucUser = MUCUser.from((Stanza)presence);
        return mucUser != null && mucUser.getStatus().contains(MUCUser.Status.ROOM_CREATED_201);
    }

    public void join(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.join(nickname, null, null, this.connection.getPacketReplyTimeout());
    }

    public void join(String nickname, String password) throws XMPPException.XMPPErrorException, SmackException {
        this.join(nickname, password, null, this.connection.getPacketReplyTimeout());
    }

    public synchronized void join(String nickname, String password, DiscussionHistory history, long timeout) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        if (this.joined) {
            this.leave();
        }
        this.enter(nickname, password, history, timeout);
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() throws SmackException.NotConnectedException {
        if (!this.joined) {
            return;
        }
        Presence leavePresence = new Presence(Presence.Type.unavailable);
        leavePresence.setTo(this.room + "/" + this.nickname);
        this.connection.sendStanza((Stanza)leavePresence);
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public Form getConfigurationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        IQ answer = (IQ)this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
        return Form.getFormFrom((Stanza)answer);
    }

    public void sendConfigurationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        iq.addExtension(form.getDataFormToSend());
        this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
    }

    public Form getRegistrationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.get);
        reg.setTo(this.room);
        IQ result = (IQ)this.connection.createPacketCollectorAndSend((IQ)reg).nextResultOrThrow();
        return Form.getFormFrom((Stanza)result);
    }

    public void sendRegistrationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.set);
        reg.setTo(this.room);
        reg.addExtension(form.getDataFormToSend());
        this.connection.createPacketCollectorAndSend((IQ)reg).nextResultOrThrow();
    }

    public void destroy(String reason, String alternateJID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        Destroy destroy = new Destroy();
        destroy.setReason(reason);
        destroy.setJid(alternateJID);
        iq.setDestroy(destroy);
        this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public void invite(String user, String reason) throws SmackException.NotConnectedException {
        this.invite(new Message(), user, reason);
    }

    public void invite(Message message, String user, String reason) throws SmackException.NotConnectedException {
        message.setTo(this.room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setTo(user);
        invite.setReason(reason);
        mucUser.setInvite(invite);
        message.addExtension((ExtensionElement)mucUser);
        this.connection.sendStanza((Stanza)message);
    }

    public boolean addInvitationRejectionListener(InvitationRejectionListener listener) {
        return this.invitationRejectionListeners.add(listener);
    }

    public boolean removeInvitationRejectionListener(InvitationRejectionListener listener) {
        return this.invitationRejectionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(String invitee, String reason) {
        InvitationRejectionListener[] invitationRejectionListenerArray = this.invitationRejectionListeners;
        synchronized (this.invitationRejectionListeners) {
            InvitationRejectionListener[] listeners = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(listeners);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (InvitationRejectionListener listener : listeners) {
                listener.invitationDeclined(invitee, reason);
            }
            return;
        }
    }

    public boolean addSubjectUpdatedListener(SubjectUpdatedListener listener) {
        return this.subjectUpdatedListeners.add(listener);
    }

    public boolean removeSubjectUpdatedListener(SubjectUpdatedListener listener) {
        return this.subjectUpdatedListeners.remove(listener);
    }

    public void addPresenceInterceptor(PresenceListener presenceInterceptor) {
        this.presenceInterceptors.add(presenceInterceptor);
    }

    public void removePresenceInterceptor(StanzaListener presenceInterceptor) {
        this.presenceInterceptors.remove(presenceInterceptor);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() throws SmackException {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator<DiscoverInfo.Identity> iterator = result.getIdentities().iterator();
            if (iterator.hasNext()) {
                DiscoverInfo.Identity identity = iterator.next();
                return identity.getName();
            }
        }
        catch (XMPPException e) {
            LOGGER.log(Level.SEVERE, "Error retrieving room nickname", e);
        }
        return null;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void changeNickname(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        StringUtils.requireNotNullOrEmpty((CharSequence)nickname, (String)"Nickname must not be null or blank.");
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change nickname.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(this.room + "/" + nickname);
        AndFilter responseFilter = new AndFilter(new StanzaFilter[]{FromMatchesFilter.createFull((String)(this.room + "/" + nickname)), new StanzaTypeFilter(Presence.class)});
        PacketCollector response = this.connection.createPacketCollectorAndSend((StanzaFilter)responseFilter, (Stanza)joinPresence);
        response.nextResultOrThrow();
        this.nickname = nickname;
    }

    public void changeAvailabilityStatus(String status, Presence.Mode mode) throws SmackException.NotConnectedException {
        StringUtils.requireNotNullOrEmpty((CharSequence)this.nickname, (String)"Nickname must not be null or blank.");
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change the availability status.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setStatus(status);
        joinPresence.setMode(mode);
        joinPresence.setTo(this.room + "/" + this.nickname);
        this.connection.sendStanza((Stanza)joinPresence);
    }

    public void kickParticipant(String nickname, String reason) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, MUCRole.none, reason);
    }

    public void requestVoice() throws SmackException.NotConnectedException {
        DataForm form = new DataForm(DataForm.Type.submit);
        FormField formTypeField = new FormField("FORM_TYPE");
        formTypeField.addValue("http://jabber.org/protocol/muc#request");
        form.addField(formTypeField);
        FormField requestVoiceField = new FormField("muc#role");
        requestVoiceField.setType(FormField.Type.text_single);
        requestVoiceField.setLabel("Requested role");
        requestVoiceField.addValue("participant");
        form.addField(requestVoiceField);
        Message message = new Message(this.room);
        message.addExtension((ExtensionElement)form);
        this.connection.sendStanza((Stanza)message);
    }

    public void grantVoice(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, MUCRole.participant);
    }

    public void grantVoice(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, MUCRole.participant, null);
    }

    public void revokeVoice(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, MUCRole.visitor);
    }

    public void revokeVoice(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, MUCRole.visitor, null);
    }

    public void banUsers(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.outcast);
    }

    public void banUser(String jid, String reason) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.outcast, reason);
    }

    public void grantMembership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.member);
    }

    public void grantMembership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.member, null);
    }

    public void revokeMembership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.none);
    }

    public void revokeMembership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.none, null);
    }

    public void grantModerator(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, MUCRole.moderator);
    }

    public void grantModerator(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, MUCRole.moderator, null);
    }

    public void revokeModerator(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, MUCRole.participant);
    }

    public void revokeModerator(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, MUCRole.participant, null);
    }

    public void grantOwnership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.owner);
    }

    public void grantOwnership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.owner, null);
    }

    public void revokeOwnership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void revokeOwnership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.admin, null);
    }

    public void grantAdmin(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void grantAdmin(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.admin);
    }

    public void revokeAdmin(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void revokeAdmin(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.member);
    }

    private void changeAffiliationByAdmin(String jid, MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, affiliation, null);
    }

    private void changeAffiliationByAdmin(String jid, MUCAffiliation affiliation, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        MUCItem item = new MUCItem(affiliation, jid, reason);
        iq.addItem(item);
        this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(Collection<String> jids, MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        for (String jid : jids) {
            MUCItem item = new MUCItem(affiliation, jid);
            iq.addItem(item);
        }
        this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
    }

    private void changeRole(String nickname, MUCRole role, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        MUCItem item = new MUCItem(role, nickname, reason);
        iq.addItem(item);
        this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
    }

    private void changeRole(Collection<String> nicknames, MUCRole role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        for (String nickname : nicknames) {
            MUCItem item = new MUCItem(role, nickname);
            iq.addItem(item);
        }
        this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public List<String> getOccupants() {
        return Collections.unmodifiableList(new ArrayList<String>(this.occupantsMap.keySet()));
    }

    public Presence getOccupantPresence(String user) {
        return this.occupantsMap.get(user);
    }

    public Occupant getOccupant(String user) {
        Presence presence = this.occupantsMap.get(user);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public boolean addParticipantListener(PresenceListener listener) {
        return this.presenceListeners.add(listener);
    }

    public boolean removeParticipantListener(PresenceListener listener) {
        return this.presenceListeners.remove(listener);
    }

    public List<Affiliate> getOwners() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.owner);
    }

    public List<Affiliate> getAdmins() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.admin);
    }

    public List<Affiliate> getMembers() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.member);
    }

    public List<Affiliate> getOutcasts() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.outcast);
    }

    private List<Affiliate> getAffiliatesByAdmin(MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        MUCItem item = new MUCItem(affiliation);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        for (MUCItem mucadminItem : answer.getItems()) {
            affiliates.add(new Affiliate(mucadminItem));
        }
        return affiliates;
    }

    public List<Occupant> getModerators() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getOccupants(MUCRole.moderator);
    }

    public List<Occupant> getParticipants() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getOccupants(MUCRole.participant);
    }

    private List<Occupant> getOccupants(MUCRole role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        MUCItem item = new MUCItem(role);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createPacketCollectorAndSend((IQ)iq).nextResultOrThrow();
        ArrayList<Occupant> participants = new ArrayList<Occupant>();
        for (MUCItem mucadminItem : answer.getItems()) {
            participants.add(new Occupant(mucadminItem));
        }
        return participants;
    }

    public void sendMessage(String text) throws SmackException.NotConnectedException {
        Message message = this.createMessage();
        message.setBody(text);
        this.connection.sendStanza((Stanza)message);
    }

    public Chat createPrivateChat(String occupant, ChatMessageListener listener) {
        return ChatManager.getInstanceFor((XMPPConnection)this.connection).createChat(occupant, listener);
    }

    public Message createMessage() {
        return new Message(this.room, Message.Type.groupchat);
    }

    public void sendMessage(Message message) throws SmackException.NotConnectedException {
        message.setTo(this.room);
        message.setType(Message.Type.groupchat);
        this.connection.sendStanza((Stanza)message);
    }

    public Message pollMessage() throws MUCNotJoinedException {
        if (this.messageCollector == null) {
            throw new MUCNotJoinedException(this);
        }
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() throws MUCNotJoinedException {
        if (this.messageCollector == null) {
            throw new MUCNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) throws MUCNotJoinedException {
        if (this.messageCollector == null) {
            throw new MUCNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public boolean addMessageListener(MessageListener listener) {
        return this.messageListeners.add(listener);
    }

    public boolean removeMessageListener(MessageListener listener) {
        return this.messageListeners.remove(listener);
    }

    public void changeSubject(final String subject) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Message message = this.createMessage();
        message.setSubject(subject);
        AndFilter responseFilter = new AndFilter(new StanzaFilter[]{this.fromRoomGroupchatFilter, new StanzaFilter(){

            public boolean accept(Stanza packet) {
                Message msg = (Message)packet;
                return subject.equals(msg.getSubject());
            }
        }});
        PacketCollector response = this.connection.createPacketCollectorAndSend((StanzaFilter)responseFilter, (Stanza)message);
        response.nextResultOrThrow();
    }

    private void removeConnectionCallbacks() {
        this.connection.removeSyncStanzaListener(this.messageListener);
        this.connection.removeSyncStanzaListener(this.presenceListener);
        this.connection.removeSyncStanzaListener(this.declinesListener);
        this.connection.removePacketInterceptor(this.presenceInterceptor);
        if (this.messageCollector != null) {
            this.messageCollector.cancel();
            this.messageCollector = null;
        }
    }

    private synchronized void userHasLeft() {
        this.multiUserChatManager.removeJoinedRoom(this.room);
        this.removeConnectionCallbacks();
    }

    public boolean addUserStatusListener(UserStatusListener listener) {
        return this.userStatusListeners.add(listener);
    }

    public boolean removeUserStatusListener(UserStatusListener listener) {
        return this.userStatusListeners.remove(listener);
    }

    public boolean addParticipantStatusListener(ParticipantStatusListener listener) {
        return this.participantStatusListeners.add(listener);
    }

    public boolean removeParticipantStatusListener(ParticipantStatusListener listener) {
        return this.participantStatusListeners.remove(listener);
    }

    private void checkRoleModifications(MUCRole oldRole, MUCRole newRole, boolean isUserModification, String from) {
        block30: {
            block29: {
                if (("visitor".equals((Object)oldRole) || "none".equals((Object)oldRole)) && "participant".equals((Object)newRole)) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceGranted(from);
                        }
                    }
                } else if ("participant".equals((Object)oldRole) && ("visitor".equals((Object)newRole) || "none".equals((Object)newRole))) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceRevoked();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceRevoked(from);
                        }
                    }
                }
                if ("moderator".equals((Object)oldRole) || !"moderator".equals((Object)newRole)) break block29;
                if ("visitor".equals((Object)oldRole) || "none".equals((Object)oldRole)) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceGranted(from);
                        }
                    }
                }
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.moderatorGranted();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.moderatorGranted(from);
                    }
                }
                break block30;
            }
            if (!"moderator".equals((Object)oldRole) || "moderator".equals((Object)newRole)) break block30;
            if ("visitor".equals((Object)newRole) || "none".equals((Object)newRole)) {
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.voiceRevoked();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.voiceRevoked(from);
                    }
                }
            }
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.moderatorRevoked();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.moderatorRevoked(from);
                }
            }
        }
    }

    private void checkAffiliationModifications(MUCAffiliation oldAffiliation, MUCAffiliation newAffiliation, boolean isUserModification, String from) {
        block30: {
            block31: {
                block29: {
                    if ("owner".equals((Object)oldAffiliation) && !"owner".equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.ownershipRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.ownershipRevoked(from);
                            }
                        }
                    } else if ("admin".equals((Object)oldAffiliation) && !"admin".equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.adminRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.adminRevoked(from);
                            }
                        }
                    } else if ("member".equals((Object)oldAffiliation) && !"member".equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.membershipRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.membershipRevoked(from);
                            }
                        }
                    }
                    if ("owner".equals((Object)oldAffiliation) || !"owner".equals((Object)newAffiliation)) break block29;
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.ownershipGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.ownershipGranted(from);
                        }
                    }
                    break block30;
                }
                if ("admin".equals((Object)oldAffiliation) || !"admin".equals((Object)newAffiliation)) break block31;
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.adminGranted();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.adminGranted(from);
                    }
                }
                break block30;
            }
            if ("member".equals((Object)oldAffiliation) || !"member".equals((Object)newAffiliation)) break block30;
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.membershipGranted();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.membershipGranted(from);
                }
            }
        }
    }

    private void checkPresenceCode(Set<MUCUser.Status> statusCodes, boolean isUserModification, MUCUser mucUser, String from) {
        if (statusCodes.contains(MUCUser.Status.KICKED_307)) {
            if (isUserModification) {
                this.joined = false;
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.kicked(mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.kicked(from, mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            }
        }
        if (statusCodes.contains(MUCUser.Status.BANNED_301)) {
            if (isUserModification) {
                this.joined = false;
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.banned(mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.banned(from, mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            }
        }
        if (statusCodes.contains(MUCUser.Status.REMOVED_AFFIL_CHANGE_321) && isUserModification) {
            this.joined = false;
            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                userStatusListener.membershipRevoked();
            }
            this.occupantsMap.clear();
            this.nickname = null;
            this.userHasLeft();
        }
        if (statusCodes.contains(MUCUser.Status.NEW_NICKNAME_303)) {
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.nicknameChanged(from, mucUser.getItem().getNick());
            }
        }
    }

    public String toString() {
        return "MUC: " + this.room + "(" + this.connection.getUser() + ")";
    }
}

