/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;

public class Socks5TestProxy {
    private static Socks5TestProxy socks5Server;
    private Socks5ServerProcess serverProcess;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private final Map<String, Socket> connectionMap = new ConcurrentHashMap<String, Socket>();
    private int port = 7777;
    private boolean startupComplete;

    private Socks5TestProxy(int port) {
        this.serverProcess = new Socks5ServerProcess();
        this.port = port;
    }

    public static synchronized Socks5TestProxy getProxy(int port) {
        if (socks5Server == null) {
            socks5Server = new Socks5TestProxy(port);
            socks5Server.start();
        }
        return socks5Server;
    }

    public static synchronized void stopProxy() {
        if (socks5Server != null) {
            socks5Server.stop();
            socks5Server = null;
        }
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            this.serverSocket = new ServerSocket(this.port);
            this.serverThread = new Thread(this.serverProcess);
            this.serverThread.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.serverThread != null && this.serverThread.isAlive()) {
            try {
                this.serverThread.interrupt();
                this.serverThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.serverThread = null;
        this.serverSocket = null;
    }

    public String getAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public int getPort() {
        if (!this.isRunning()) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket(String digest) {
        Socks5TestProxy socks5TestProxy = this;
        synchronized (socks5TestProxy) {
            block9: {
                if (!this.startupComplete) {
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (this.startupComplete) break block9;
                        throw new IllegalStateException("Startup of Socks5TestProxy failed within 5 seconds");
                    }
                }
            }
        }
        return this.connectionMap.get(digest);
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    class Socks5ServerProcess
    implements Runnable {
        Socks5ServerProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Socket socket = null;
                try {
                    if (Socks5TestProxy.this.serverSocket.isClosed() || Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    socket = Socks5TestProxy.this.serverSocket.accept();
                    this.establishConnection(socket);
                    Socks5ServerProcess socks5ServerProcess = this;
                    synchronized (socks5ServerProcess) {
                        Socks5TestProxy.this.startupComplete = true;
                        this.notify();
                        continue;
                    }
                }
                catch (SocketException socketException) {
                    continue;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        socket.close();
                    }
                    catch (IOException iOException) {
                    }
                    continue;
                }
                break;
            }
        }

        private void establishConnection(Socket socket) throws IOException, SmackException {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int b = in.read();
            if (b != 5) {
                throw new SmackException("Only SOCKS5 supported");
            }
            b = in.read();
            byte[] auth = new byte[b];
            in.readFully(auth);
            byte[] authMethodSelectionResponse = new byte[2];
            authMethodSelectionResponse[0] = 5;
            boolean noAuthMethodFound = false;
            for (int i = 0; i < auth.length; ++i) {
                if (auth[i] != 0) continue;
                noAuthMethodFound = true;
                break;
            }
            if (!noAuthMethodFound) {
                authMethodSelectionResponse[1] = -1;
                out.write(authMethodSelectionResponse);
                out.flush();
                throw new SmackException("Authentication method not supported");
            }
            authMethodSelectionResponse[1] = 0;
            out.write(authMethodSelectionResponse);
            out.flush();
            byte[] connectionRequest = Socks5Utils.receiveSocks5Message((DataInputStream)in);
            String responseDigest = new String(connectionRequest, 5, (int)connectionRequest[4]);
            connectionRequest[1] = 0;
            out.write(connectionRequest);
            out.flush();
            Socks5TestProxy.this.connectionMap.put(responseDigest, socket);
        }
    }
}

