/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class InBandBytestreamRequestTest {
    static final Jid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    static final Jid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    String sessionID = "session_id";
    XMPPConnection connection;
    InBandBytestreamManager byteStreamManager;
    Open initBytestream;

    @Before
    public void setup() {
        this.connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        this.byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        this.initBytestream = new Open(this.sessionID, 4096);
        this.initBytestream.setFrom(initiatorJID);
        this.initBytestream.setTo(targetJID);
    }

    @Test
    public void shouldReplyWithErrorIfRequestIsRejected() throws SmackException.NotConnectedException, InterruptedException {
        InBandBytestreamRequest ibbRequest = new InBandBytestreamRequest(this.byteStreamManager, this.initBytestream);
        ibbRequest.reject();
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendStanza((Stanza)argument.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.not_acceptable, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldReturnSessionIfRequestIsAccepted() throws Exception {
        InBandBytestreamRequest ibbRequest = new InBandBytestreamRequest(this.byteStreamManager, this.initBytestream);
        InBandBytestreamSession session = ibbRequest.accept();
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendStanza((Stanza)argument.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.result, (Object)((IQ)argument.getValue()).getType());
        Assert.assertNotNull((Object)session);
        Assert.assertNotNull((Object)session.getInputStream());
        Assert.assertNotNull((Object)session.getOutputStream());
    }
}

