/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb.packet;

import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import org.custommonkey.xmlunit.XMLAssert;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.impl.JidCreate;

public class CloseTest {
    private static Properties outputProperties = new Properties();

    public CloseTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArguments1() {
        new Close(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotInstantiateWithInvalidArguments2() {
        new Close("");
    }

    @Test
    public void shouldBeOfIQTypeSET() {
        Close close = new Close("sessionID");
        Assert.assertEquals((Object)IQ.Type.set, (Object)close.getType());
    }

    @Test
    public void shouldSetAllFieldsCorrectly() {
        Close close = new Close("sessionID");
        Assert.assertEquals((Object)"sessionID", (Object)close.getSessionID());
    }

    @Test
    public void shouldReturnValidIQStanzaXML() throws Exception {
        String control = XMLBuilder.create((String)"iq").a("to", "juliet@capulet.lit/balcony").a("from", "romeo@montague.lit/orchard").a("id", "us71g45j").a("type", "set").e("close").a("xmlns", "http://jabber.org/protocol/ibb").a("sid", "i781hf64").asString(outputProperties);
        Close close = new Close("i781hf64");
        close.setFrom(JidCreate.from((String)"romeo@montague.lit/orchard"));
        close.setTo(JidCreate.from((String)"juliet@capulet.lit/balcony"));
        close.setStanzaId("us71g45j");
        XMLAssert.assertXMLEqual((String)control, (String)close.toXML().toString());
    }
}

