/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.InitiationListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamListener;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5PacketUtils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.reflect.Whitebox;

public class InitiationListenerTest {
    static final FullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    static final FullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    static final DomainBareJid xmppServer = JidTestUtil.DOMAIN_BARE_JID_1;
    static final DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    String proxyAddress = "127.0.0.1";
    String sessionID = "session_id";
    XMPPConnection connection;
    Socks5BytestreamManager byteStreamManager;
    InitiationListener initiationListener;
    Bytestream initBytestream;

    @Before
    public void setup() {
        this.connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection);
        this.byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)this.connection);
        this.initiationListener = (InitiationListener)Whitebox.getInternalState((Object)this.byteStreamManager, InitiationListener.class);
        this.initBytestream = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, this.sessionID);
        this.initBytestream.addStreamHost((Jid)proxyJID, this.proxyAddress, 7777);
    }

    @Test
    public void shouldRespondWithError() throws Exception {
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendStanza((Stanza)argument.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.not_acceptable, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldInvokeListenerForAllRequests() throws Exception {
        Socks5BytestreamListener listener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)listener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldInvokeListenerForUser() throws Exception {
        Socks5BytestreamListener listener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, (Jid)initiatorJID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)listener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((BytestreamRequest)byteStreamRequest.getValue()).getFrom());
    }

    @Test
    public void shouldNotInvokeListenerForUser() throws Exception {
        Socks5BytestreamListener listener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)listener, JidCreate.from((String)("other_" + initiatorJID)));
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendStanza((Stanza)argument.capture());
        Assert.assertEquals((Object)initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.not_acceptable, (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldNotInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        Socks5BytestreamListener allRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        Socks5BytestreamListener userRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, (Jid)initiatorJID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldInvokeAllRequestsListenerIfUserListenerExists() throws Exception {
        Socks5BytestreamListener allRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        Socks5BytestreamListener userRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, JidCreate.from((String)("other_" + initiatorJID)));
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }

    @Test
    public void shouldIgnoreSocks5BytestreamRequestOnce() throws Exception {
        Socks5BytestreamListener allRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)allRequestsListener);
        Socks5BytestreamListener userRequestsListener = (Socks5BytestreamListener)Mockito.mock(Socks5BytestreamListener.class);
        this.byteStreamManager.addIncomingBytestreamListener((BytestreamListener)userRequestsListener, (Jid)initiatorJID);
        this.byteStreamManager.ignoreBytestreamRequestOnce(this.sessionID);
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ArgumentCaptor byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        this.initiationListener.handleIQRequest((IQ)this.initBytestream);
        Thread.sleep(200L);
        ((Socks5BytestreamListener)Mockito.verify((Object)userRequestsListener)).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
        byteStreamRequest = ArgumentCaptor.forClass(BytestreamRequest.class);
        ((Socks5BytestreamListener)Mockito.verify((Object)allRequestsListener, (VerificationMode)Mockito.never())).incomingBytestreamRequest((BytestreamRequest)byteStreamRequest.capture());
    }
}

