/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class Socks5ClientTest {
    private String serverAddress = "127.0.0.1";
    private int serverPort = 7890;
    private DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    private String digest = "digest";
    private ServerSocket serverSocket;

    @Before
    public void setup() throws Exception {
        this.serverSocket = new ServerSocket(this.serverPort);
    }

    @Test
    public void shouldCloseSocketIfServerDoesNotAcceptAuthenticationMethod() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    socks5Client.getSocket(10000);
                    Assert.fail((String)"exception should be thrown");
                }
                catch (SmackException e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("SOCKS5 negotiation failed"));
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)1L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        out.write(new byte[]{5, -1});
        out.flush();
        serverThread.join();
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    @Test
    public void shouldCloseSocketIfServerRepliesInUnsupportedWay() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    socks5Client.getSocket(10000);
                    Assert.fail((String)"exception should be thrown");
                }
                catch (SmackException e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("Unsupported SOCKS5 address type"));
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)1L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        out.write(new byte[]{5, 0});
        out.flush();
        Socks5Utils.receiveSocks5Message((DataInputStream)in);
        out.write(new byte[]{5, 0, 0, 1, 0});
        out.flush();
        serverThread.join();
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    @Test
    public void shouldCloseSocketIfServerRepliesWithError() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    socks5Client.getSocket(10000);
                    Assert.fail((String)"exception should be thrown");
                }
                catch (SmackException e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("SOCKS5 negotiation failed"));
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)1L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        out.write(new byte[]{5, 0});
        out.flush();
        Socks5Utils.receiveSocks5Message((DataInputStream)in);
        out.write(new byte[]{5, 1, 0, 3});
        byte[] address = this.digest.getBytes();
        out.write(address.length);
        out.write(address);
        out.write(new byte[]{0, 0});
        out.flush();
        serverThread.join();
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    @Test
    public void shouldSuccessfullyConnectToSocks5Server() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)Socks5ClientTest.this.proxyJID, Socks5ClientTest.this.serverAddress, Socks5ClientTest.this.serverPort);
                Socks5Client socks5Client = new Socks5Client(streamHost, Socks5ClientTest.this.digest);
                try {
                    Socket socket = socks5Client.getSocket(10000);
                    Assert.assertNotNull((Object)socket);
                    socket.getOutputStream().write(123);
                    socket.close();
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        serverThread.start();
        Socket socket = this.serverSocket.accept();
        DataInputStream in = new DataInputStream(socket.getInputStream());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)1L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        out.write(new byte[]{5, 0});
        out.flush();
        byte[] address = this.digest.getBytes();
        Assert.assertEquals((long)5L, (long)((byte)in.read()));
        Assert.assertEquals((long)1L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)3L, (long)((byte)in.read()));
        Assert.assertEquals((long)address.length, (long)((byte)in.read()));
        for (int i = 0; i < address.length; ++i) {
            Assert.assertEquals((long)address[i], (long)((byte)in.read()));
        }
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        Assert.assertEquals((long)0L, (long)((byte)in.read()));
        out.write(new byte[]{5, 0, 0, 3});
        out.write(address.length);
        out.write(address);
        out.write(new byte[]{0, 0});
        out.flush();
        serverThread.join();
        Assert.assertEquals((long)123L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    @After
    public void cleanup() throws Exception {
        this.serverSocket.close();
    }
}

