/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class FileTransferNegotiatorTest {
    private DummyConnection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = new DummyConnection();
        this.connection.connect();
        this.connection.login();
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection);
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void verifyForm() throws Exception {
        FileTransferNegotiator fileNeg = FileTransferNegotiator.getInstanceFor((XMPPConnection)this.connection);
        try {
            fileNeg.negotiateOutgoingTransfer((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, "streamid", "file", 1024L, null, 10);
        }
        catch (SmackException.NoResponseException e) {
            // empty catch block
        }
        Stanza packet = (Stanza)this.connection.getSentPacket();
        String xml = packet.toXML().toString();
        Assert.assertTrue((xml.indexOf("var='stream-method' type='list-single'") != -1 ? 1 : 0) != 0);
    }
}

