/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pep;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.pep.PEPListener;
import org.jivesoftware.smackx.pep.packet.PEPEvent;
import org.jivesoftware.smackx.pep.packet.PEPItem;
import org.jivesoftware.smackx.pep.packet.PEPPubSub;
import org.jxmpp.jid.Jid;

public class PEPManager {
    private List<PEPListener> pepListeners = new ArrayList<PEPListener>();
    private XMPPConnection connection;
    private StanzaFilter packetFilter = new StanzaExtensionFilter("event", "http://jabber.org/protocol/pubsub#event");
    private StanzaListener packetListener;

    public PEPManager(XMPPConnection connection) {
        this.connection = connection;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPEPListener(PEPListener pepListener) {
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            if (!this.pepListeners.contains(pepListener)) {
                this.pepListeners.add(pepListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePEPListener(PEPListener pepListener) {
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            this.pepListeners.remove(pepListener);
        }
    }

    public void publish(PEPItem item) throws SmackException.NotConnectedException, InterruptedException {
        PEPPubSub pubSub = new PEPPubSub(item);
        pubSub.setType(IQ.Type.set);
        this.connection.sendStanza((Stanza)pubSub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePEPListeners(Jid from, PEPEvent event) {
        PEPListener[] listeners = null;
        List<PEPListener> list = this.pepListeners;
        synchronized (list) {
            listeners = new PEPListener[this.pepListeners.size()];
            this.pepListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].eventReceived(from, event);
        }
    }

    private void init() {
        this.packetListener = new StanzaListener(){

            public void processPacket(Stanza packet) {
                Message message = (Message)packet;
                PEPEvent event = (PEPEvent)message.getExtension("event", "http://jabber.org/protocol/pubsub#event");
                PEPManager.this.firePEPListeners(message.getFrom(), event);
            }
        };
        this.connection.addSyncStanzaListener(this.packetListener, this.packetFilter);
    }

    public void destroy() {
        if (this.connection != null) {
            this.connection.removeSyncStanzaListener(this.packetListener);
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }
}

