/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.provider;

import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.xmlpull.v1.XmlPullParser;

public class DiscoverInfoProvider
extends IQProvider<DiscoverInfo> {
    public DiscoverInfo parse(XmlPullParser parser, int initialDepth) throws Exception {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        boolean done = false;
        DiscoverInfo.Identity identity = null;
        String category = "";
        String name = "";
        String type = "";
        String variable = "";
        String lang = "";
        discoverInfo.setNode(parser.getAttributeValue("", "node"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("identity")) {
                    category = parser.getAttributeValue("", "category");
                    name = parser.getAttributeValue("", "name");
                    type = parser.getAttributeValue("", "type");
                    lang = parser.getAttributeValue(parser.getNamespace("xml"), "lang");
                    continue;
                }
                if (parser.getName().equals("feature")) {
                    variable = parser.getAttributeValue("", "var");
                    continue;
                }
                PacketParserUtils.addExtensionElement((Stanza)discoverInfo, (XmlPullParser)parser);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("identity")) {
                identity = new DiscoverInfo.Identity(category, type, name, lang);
                discoverInfo.addIdentity(identity);
            }
            if (parser.getName().equals("feature")) {
                boolean notADuplicateFeature = discoverInfo.addFeature(variable);
                assert (notADuplicateFeature);
            }
            if (!parser.getName().equals("query")) continue;
            done = true;
        }
        return discoverInfo;
    }
}

