/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.AbstractNodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public final class MultiUserChatManager
extends Manager {
    private static final String DISCO_NODE = "http://jabber.org/protocol/muc#rooms";
    private static final Logger LOGGER = Logger.getLogger(MultiUserChatManager.class.getName());
    private static final Map<XMPPConnection, MultiUserChatManager> INSTANCES;
    private static final StanzaFilter INVITATION_FILTER;
    private final Set<InvitationListener> invitationsListeners = new CopyOnWriteArraySet<InvitationListener>();
    private final Set<EntityBareJid> joinedRooms = new HashSet<EntityBareJid>();
    private final Map<EntityBareJid, WeakReference<MultiUserChat>> multiUserChats = new HashMap<EntityBareJid, WeakReference<MultiUserChat>>();

    public static synchronized MultiUserChatManager getInstanceFor(XMPPConnection connection) {
        MultiUserChatManager multiUserChatManager = INSTANCES.get(connection);
        if (multiUserChatManager == null) {
            multiUserChatManager = new MultiUserChatManager(connection);
            INSTANCES.put(connection, multiUserChatManager);
        }
        return multiUserChatManager;
    }

    private MultiUserChatManager(XMPPConnection connection) {
        super(connection);
        StanzaListener invitationPacketListener = new StanzaListener(){

            public void processPacket(Stanza packet) {
                Message message = (Message)packet;
                MUCUser mucUser = MUCUser.from((Stanza)message);
                if (mucUser.getInvite() != null) {
                    EntityBareJid mucJid = message.getFrom().asEntityBareJidIfPossible();
                    if (mucJid == null) {
                        LOGGER.warning("Invite to non bare JID: '" + message.toXML() + "'");
                        return;
                    }
                    MultiUserChat muc = MultiUserChatManager.this.getMultiUserChat(mucJid);
                    for (InvitationListener listener : MultiUserChatManager.this.invitationsListeners) {
                        listener.invitationReceived(MultiUserChatManager.this.connection(), muc, mucUser.getInvite().getFrom(), mucUser.getInvite().getReason(), mucUser.getPassword(), message);
                    }
                }
            }
        };
        connection.addAsyncStanzaListener(invitationPacketListener, INVITATION_FILTER);
    }

    public synchronized MultiUserChat getMultiUserChat(EntityBareJid jid) {
        WeakReference<MultiUserChat> weakRefMultiUserChat = this.multiUserChats.get(jid);
        if (weakRefMultiUserChat == null) {
            return this.createNewMucAndAddToMap(jid);
        }
        MultiUserChat multiUserChat = (MultiUserChat)weakRefMultiUserChat.get();
        if (multiUserChat == null) {
            return this.createNewMucAndAddToMap(jid);
        }
        return multiUserChat;
    }

    private MultiUserChat createNewMucAndAddToMap(EntityBareJid jid) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection(), jid, this);
        this.multiUserChats.put(jid, new WeakReference<MultiUserChat>(multiUserChat));
        return multiUserChat;
    }

    public boolean isServiceEnabled(Jid user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(user, "http://jabber.org/protocol/muc");
    }

    public Set<EntityBareJid> getJoinedRooms() {
        return Collections.unmodifiableSet(this.joinedRooms);
    }

    public List<EntityBareJid> getJoinedRooms(EntityJid user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems result = ServiceDiscoveryManager.getInstanceFor(this.connection()).discoverItems((Jid)user, DISCO_NODE);
        List<DiscoverItems.Item> items = result.getItems();
        ArrayList<EntityBareJid> answer = new ArrayList<EntityBareJid>(items.size());
        for (DiscoverItems.Item item : items) {
            EntityBareJid muc = item.getEntityID().asEntityBareJidIfPossible();
            if (muc == null) {
                LOGGER.warning("Not a bare JID: " + item.getEntityID());
                continue;
            }
            answer.add(muc);
        }
        return answer;
    }

    public RoomInfo getRoomInfo(EntityBareJid room) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(this.connection()).discoverInfo((Jid)room);
        return new RoomInfo(info);
    }

    public List<DomainBareJid> getXMPPServiceDomains() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return sdm.findServices("http://jabber.org/protocol/muc", false, false);
    }

    public boolean providesMucService(DomainBareJid domainBareJid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature((Jid)domainBareJid, "http://jabber.org/protocol/muc");
    }

    public List<HostedRoom> getHostedRooms(DomainBareJid serviceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        if (!this.providesMucService(serviceName)) {
            throw new MultiUserChatException.NotAMucServiceException(serviceName);
        }
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(this.connection());
        DiscoverItems discoverItems = discoManager.discoverItems((Jid)serviceName);
        List<DiscoverItems.Item> items = discoverItems.getItems();
        ArrayList<HostedRoom> answer = new ArrayList<HostedRoom>(items.size());
        for (DiscoverItems.Item item : items) {
            answer.add(new HostedRoom(item));
        }
        return answer;
    }

    public void decline(EntityBareJid room, String inviter, String reason) throws SmackException.NotConnectedException, InterruptedException {
        Message message = new Message((Jid)room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(inviter);
        decline.setReason(reason);
        mucUser.setDecline(decline);
        message.addExtension((ExtensionElement)mucUser);
        this.connection().sendStanza((Stanza)message);
    }

    public void addInvitationListener(InvitationListener listener) {
        this.invitationsListeners.add(listener);
    }

    public void removeInvitationListener(InvitationListener listener) {
        this.invitationsListeners.remove(listener);
    }

    void addJoinedRoom(EntityBareJid room) {
        this.joinedRooms.add(room);
    }

    void removeJoinedRoom(EntityBareJid room) {
        this.joinedRooms.remove(room);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature("http://jabber.org/protocol/muc");
                final WeakReference<XMPPConnection> weakRefConnection = new WeakReference<XMPPConnection>(connection);
                ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(MultiUserChatManager.DISCO_NODE, new AbstractNodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        XMPPConnection connection = (XMPPConnection)weakRefConnection.get();
                        if (connection == null) {
                            return Collections.emptyList();
                        }
                        Set<EntityBareJid> joinedRooms = MultiUserChatManager.getInstanceFor(connection).getJoinedRooms();
                        ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                        for (EntityBareJid room : joinedRooms) {
                            answer.add(new DiscoverItems.Item((Jid)room));
                        }
                        return answer;
                    }
                });
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, MultiUserChatManager>();
        INVITATION_FILTER = new AndFilter(new StanzaFilter[]{StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter((ExtensionElement)new MUCUser()), new NotFilter(MessageTypeFilter.ERROR)});
    }
}

