/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.packet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.vcardtemp.VCardManager;
import org.jxmpp.jid.EntityBareJid;

public class VCard
extends IQ {
    public static final String ELEMENT = "vCard";
    public static final String NAMESPACE = "vcard-temp";
    private static final Logger LOGGER = Logger.getLogger(VCard.class.getName());
    private static final String DEFAULT_MIME_TYPE = "image/jpeg";
    private Map<String, String> homePhones = new HashMap<String, String>();
    private Map<String, String> workPhones = new HashMap<String, String>();
    private Map<String, String> homeAddr = new HashMap<String, String>();
    private Map<String, String> workAddr = new HashMap<String, String>();
    private String firstName;
    private String lastName;
    private String middleName;
    private String prefix;
    private String suffix;
    private String emailHome;
    private String emailWork;
    private String organization;
    private String organizationUnit;
    private String photoMimeType;
    private String photoBinval;
    private Map<String, String> otherSimpleFields = new HashMap<String, String>();
    private Map<String, String> otherUnescapableFields = new HashMap<String, String>();

    public VCard() {
        super(ELEMENT, NAMESPACE);
    }

    public String getField(String field) {
        return this.otherSimpleFields.get(field);
    }

    public void setField(String field, String value) {
        this.setField(field, value, false);
    }

    public void setField(String field, String value, boolean isUnescapable) {
        if (!isUnescapable) {
            this.otherSimpleFields.put(field, value);
        } else {
            this.otherUnescapableFields.put(field, value);
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.updateFN();
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.updateFN();
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
        this.updateFN();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.updateFN();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.updateFN();
    }

    public String getNickName() {
        return this.otherSimpleFields.get("NICKNAME");
    }

    public void setNickName(String nickName) {
        this.otherSimpleFields.put("NICKNAME", nickName);
    }

    public String getEmailHome() {
        return this.emailHome;
    }

    public void setEmailHome(String email) {
        this.emailHome = email;
    }

    public String getEmailWork() {
        return this.emailWork;
    }

    public void setEmailWork(String emailWork) {
        this.emailWork = emailWork;
    }

    public String getJabberId() {
        return this.otherSimpleFields.get("JABBERID");
    }

    public void setJabberId(String jabberId) {
        this.otherSimpleFields.put("JABBERID", jabberId);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public String getAddressFieldHome(String addrField) {
        return this.homeAddr.get(addrField);
    }

    public void setAddressFieldHome(String addrField, String value) {
        this.homeAddr.put(addrField, value);
    }

    public String getAddressFieldWork(String addrField) {
        return this.workAddr.get(addrField);
    }

    public void setAddressFieldWork(String addrField, String value) {
        this.workAddr.put(addrField, value);
    }

    public void setPhoneHome(String phoneType, String phoneNum) {
        this.homePhones.put(phoneType, phoneNum);
    }

    public String getPhoneHome(String phoneType) {
        return this.homePhones.get(phoneType);
    }

    public void setPhoneWork(String phoneType, String phoneNum) {
        this.workPhones.put(phoneType, phoneNum);
    }

    public String getPhoneWork(String phoneType) {
        return this.workPhones.get(phoneType);
    }

    public void setAvatar(URL avatarURL) {
        byte[] bytes = new byte[]{};
        try {
            bytes = VCard.getBytes(avatarURL);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error getting bytes from URL: " + avatarURL, e);
        }
        this.setAvatar(bytes);
    }

    public void removeAvatar() {
        this.photoBinval = null;
        this.photoMimeType = null;
    }

    public void setAvatar(byte[] bytes) {
        this.setAvatar(bytes, DEFAULT_MIME_TYPE);
    }

    public void setAvatar(byte[] bytes, String mimeType) {
        if (bytes == null) {
            this.removeAvatar();
            return;
        }
        String encodedImage = Base64.encodeToString((byte[])bytes);
        this.setAvatar(encodedImage, mimeType);
    }

    public void setAvatar(String encodedImage, String mimeType) {
        this.photoBinval = encodedImage;
        this.photoMimeType = mimeType;
    }

    @Deprecated
    public void setEncodedImage(String encodedAvatar) {
        this.setAvatar(encodedAvatar, DEFAULT_MIME_TYPE);
    }

    public byte[] getAvatar() {
        if (this.photoBinval == null) {
            return null;
        }
        return Base64.decode((String)this.photoBinval);
    }

    public String getAvatarMimeType() {
        return this.photoMimeType;
    }

    public static byte[] getBytes(URL url) throws IOException {
        String path = url.getPath();
        File file = new File(path);
        if (file.exists()) {
            return VCard.getFileBytes(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileBytes(File file) throws IOException {
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(new FileInputStream(file));
            int bytes = (int)file.length();
            byte[] buffer = new byte[bytes];
            int readBytes = bis.read(buffer);
            if (readBytes != buffer.length) {
                throw new IOException("Entire file not read");
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    public String getAvatarHash() {
        MessageDigest digest;
        byte[] bytes = this.getAvatar();
        if (bytes == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "Failed to get message digest", e);
            return null;
        }
        digest.update(bytes);
        return StringUtils.encodeHex((byte[])digest.digest());
    }

    private void updateFN() {
        StringBuilder sb = new StringBuilder();
        if (this.firstName != null) {
            sb.append(StringUtils.escapeForXML((CharSequence)this.firstName)).append(' ');
        }
        if (this.middleName != null) {
            sb.append(StringUtils.escapeForXML((CharSequence)this.middleName)).append(' ');
        }
        if (this.lastName != null) {
            sb.append(StringUtils.escapeForXML((CharSequence)this.lastName));
        }
        this.setField("FN", sb.toString());
    }

    @Deprecated
    public void save(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        VCardManager.getInstanceFor(connection).saveVCard(this);
    }

    @Deprecated
    public void load(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.load(connection, null);
    }

    @Deprecated
    public void load(XMPPConnection connection, EntityBareJid user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        VCard result = VCardManager.getInstanceFor(connection).loadVCard(user);
        this.copyFieldsFrom(result);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        String number;
        String value;
        if (!this.hasContent()) {
            xml.setEmptyElement();
            return xml;
        }
        xml.rightAngleBracket();
        if (this.hasNameField()) {
            xml.openElement("N");
            xml.optElement("FAMILY", this.lastName);
            xml.optElement("GIVEN", this.firstName);
            xml.optElement("MIDDLE", this.middleName);
            xml.optElement("PREFIX", this.prefix);
            xml.optElement("SUFFIX", this.suffix);
            xml.closeElement("N");
        }
        if (this.hasOrganizationFields()) {
            xml.openElement("ORG");
            xml.optElement("ORGNAME", this.organization);
            xml.optElement("ORGUNIT", this.organizationUnit);
            xml.closeElement("ORG");
        }
        for (Map.Entry<String, String> entry : this.otherSimpleFields.entrySet()) {
            xml.optElement(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.otherUnescapableFields.entrySet()) {
            value = entry.getValue();
            if (value == null) continue;
            xml.openElement(entry.getKey());
            xml.append((CharSequence)value);
            xml.closeElement(entry.getKey());
        }
        if (this.photoBinval != null) {
            xml.openElement("PHOTO");
            xml.escapedElement("BINVAL", this.photoBinval);
            xml.element("TYPE", this.photoMimeType);
            xml.closeElement("PHOTO");
        }
        if (this.emailWork != null) {
            xml.openElement("EMAIL");
            xml.emptyElement("WORK");
            xml.emptyElement("INTERNET");
            xml.emptyElement("PREF");
            xml.element("USERID", this.emailWork);
            xml.closeElement("EMAIL");
        }
        if (this.emailHome != null) {
            xml.openElement("EMAIL");
            xml.emptyElement("HOME");
            xml.emptyElement("INTERNET");
            xml.emptyElement("PREF");
            xml.element("USERID", this.emailHome);
            xml.closeElement("EMAIL");
        }
        for (Map.Entry<String, String> phone : this.workPhones.entrySet()) {
            number = phone.getValue();
            if (number == null) continue;
            xml.openElement("TEL");
            xml.emptyElement("WORK");
            xml.emptyElement(phone.getKey());
            xml.element("NUMBER", number);
            xml.closeElement("TEL");
        }
        for (Map.Entry<String, String> phone : this.homePhones.entrySet()) {
            number = phone.getValue();
            if (number == null) continue;
            xml.openElement("TEL");
            xml.emptyElement("HOME");
            xml.emptyElement(phone.getKey());
            xml.element("NUMBER", number);
            xml.closeElement("TEL");
        }
        if (!this.workAddr.isEmpty()) {
            xml.openElement("ADR");
            xml.emptyElement("WORK");
            for (Map.Entry<String, String> entry : this.workAddr.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                xml.element(entry.getKey(), value);
            }
            xml.closeElement("ADR");
        }
        if (!this.homeAddr.isEmpty()) {
            xml.openElement("ADR");
            xml.emptyElement("HOME");
            for (Map.Entry<String, String> entry : this.homeAddr.entrySet()) {
                value = entry.getValue();
                if (value == null) continue;
                xml.element(entry.getKey(), value);
            }
            xml.closeElement("ADR");
        }
        return xml;
    }

    private void copyFieldsFrom(VCard from) {
        Field[] fields;
        for (Field field : fields = VCard.class.getDeclaredFields()) {
            if (field.getDeclaringClass() != VCard.class || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set((Object)this, field.get((Object)from));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This cannot happen:" + field, e);
            }
        }
    }

    private boolean hasContent() {
        return this.hasNameField() || this.hasOrganizationFields() || this.emailHome != null || this.emailWork != null || this.otherSimpleFields.size() > 0 || this.otherUnescapableFields.size() > 0 || this.homeAddr.size() > 0 || this.homePhones.size() > 0 || this.workAddr.size() > 0 || this.workPhones.size() > 0 || this.photoBinval != null;
    }

    private boolean hasNameField() {
        return this.firstName != null || this.lastName != null || this.middleName != null || this.prefix != null || this.suffix != null;
    }

    private boolean hasOrganizationFields() {
        return this.organization != null || this.organizationUnit != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        VCard vCard = (VCard)((Object)o);
        if (this.emailHome != null ? !this.emailHome.equals(vCard.emailHome) : vCard.emailHome != null) {
            return false;
        }
        if (this.emailWork != null ? !this.emailWork.equals(vCard.emailWork) : vCard.emailWork != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(vCard.firstName) : vCard.firstName != null) {
            return false;
        }
        if (!this.homeAddr.equals(vCard.homeAddr)) {
            return false;
        }
        if (!this.homePhones.equals(vCard.homePhones)) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(vCard.lastName) : vCard.lastName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(vCard.middleName) : vCard.middleName != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(vCard.organization) : vCard.organization != null) {
            return false;
        }
        if (this.organizationUnit != null ? !this.organizationUnit.equals(vCard.organizationUnit) : vCard.organizationUnit != null) {
            return false;
        }
        if (!this.otherSimpleFields.equals(vCard.otherSimpleFields)) {
            return false;
        }
        if (!this.workAddr.equals(vCard.workAddr)) {
            return false;
        }
        if (this.photoBinval != null ? !this.photoBinval.equals(vCard.photoBinval) : vCard.photoBinval != null) {
            return false;
        }
        return this.workPhones.equals(vCard.workPhones);
    }

    public int hashCode() {
        int result = this.homePhones.hashCode();
        result = 29 * result + this.workPhones.hashCode();
        result = 29 * result + this.homeAddr.hashCode();
        result = 29 * result + this.workAddr.hashCode();
        result = 29 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 29 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 29 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 29 * result + (this.emailHome != null ? this.emailHome.hashCode() : 0);
        result = 29 * result + (this.emailWork != null ? this.emailWork.hashCode() : 0);
        result = 29 * result + (this.organization != null ? this.organization.hashCode() : 0);
        result = 29 * result + (this.organizationUnit != null ? this.organizationUnit.hashCode() : 0);
        result = 29 * result + this.otherSimpleFields.hashCode();
        result = 29 * result + (this.photoBinval != null ? this.photoBinval.hashCode() : 0);
        return result;
    }
}

