/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smackx.amp.AMPDeliverCondition;
import org.jivesoftware.smackx.amp.AMPExpireAtCondition;
import org.jivesoftware.smackx.amp.AMPMatchResourceCondition;
import org.jivesoftware.smackx.amp.packet.AMPExtension;
import org.jivesoftware.smackx.amp.provider.AMPExtensionProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class AMPExtensionTest {
    private InputStream CORRECT_SENDING_STANZA_STREAM;
    private InputStream INCORRECT_RECEIVING_STANZA_STREAM;

    @Before
    public void setUp() {
        this.CORRECT_SENDING_STANZA_STREAM = this.getClass().getResourceAsStream("correct_stanza_test.xml");
        this.INCORRECT_RECEIVING_STANZA_STREAM = this.getClass().getResourceAsStream("incorrect_stanza_test.xml");
    }

    @Test
    public void isCorrectToXmlTransform() throws IOException {
        String correctStanza = AMPExtensionTest.toString(this.CORRECT_SENDING_STANZA_STREAM);
        AMPExtension ext = new AMPExtension();
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.alert, (AMPExtension.Condition)new AMPDeliverCondition(AMPDeliverCondition.Value.direct)));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.drop, (AMPExtension.Condition)new AMPDeliverCondition(AMPDeliverCondition.Value.forward)));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.error, (AMPExtension.Condition)new AMPDeliverCondition(AMPDeliverCondition.Value.gateway)));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.notify, (AMPExtension.Condition)new AMPDeliverCondition(AMPDeliverCondition.Value.none)));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.notify, (AMPExtension.Condition)new AMPDeliverCondition(AMPDeliverCondition.Value.stored)));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.notify, (AMPExtension.Condition)new AMPExpireAtCondition("2004-09-10T08:33:14Z")));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.notify, (AMPExtension.Condition)new AMPMatchResourceCondition(AMPMatchResourceCondition.Value.any)));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.notify, (AMPExtension.Condition)new AMPMatchResourceCondition(AMPMatchResourceCondition.Value.exact)));
        ext.addRule(new AMPExtension.Rule(AMPExtension.Action.notify, (AMPExtension.Condition)new AMPMatchResourceCondition(AMPMatchResourceCondition.Value.other)));
        Assert.assertEquals((Object)correctStanza, (Object)ext.toXML());
    }

    @Test
    public void isCorrectFromXmlErrorHandling() throws Exception {
        AMPExtensionProvider ampProvider = new AMPExtensionProvider();
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(this.INCORRECT_RECEIVING_STANZA_STREAM, "UTF-8");
        Assert.assertEquals((long)2L, (long)parser.next());
        Assert.assertEquals((Object)"amp", (Object)parser.getName());
        ExtensionElement extension = (ExtensionElement)ampProvider.parse(parser);
        Assert.assertTrue((boolean)(extension instanceof AMPExtension));
        AMPExtension amp = (AMPExtension)extension;
        Assert.assertEquals((long)0L, (long)amp.getRulesCount());
        Assert.assertEquals((Object)AMPExtension.Status.alert, (Object)amp.getStatus());
        Assert.assertEquals((Object)"bernardo@hamlet.lit/elsinore", (Object)amp.getFrom());
        Assert.assertEquals((Object)"francisco@hamlet.lit", (Object)amp.getTo());
    }

    @Test
    public void isCorrectFromXmlDeserialization() throws Exception {
        AMPExtensionProvider ampProvider = new AMPExtensionProvider();
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(this.CORRECT_SENDING_STANZA_STREAM, "UTF-8");
        Assert.assertEquals((long)2L, (long)parser.next());
        Assert.assertEquals((Object)"amp", (Object)parser.getName());
        ExtensionElement extension = (ExtensionElement)ampProvider.parse(parser);
        Assert.assertTrue((boolean)(extension instanceof AMPExtension));
        AMPExtension amp = (AMPExtension)extension;
        Assert.assertEquals((long)9L, (long)amp.getRulesCount());
    }

    private static String toString(InputStream stream) throws IOException {
        byte[] data = new byte[stream.available()];
        stream.read(data);
        stream.close();
        return new String(data, Charset.defaultCharset());
    }
}

