/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.bytestreams.ibb.IBBPacketUtils;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.mockito.Mockito;

public class InBandBytestreamManagerTest
extends InitExtensions {
    static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    static final DomainBareJid xmppServer = JidTestUtil.DOMAIN_BARE_JID_1;
    String sessionID = "session_id";
    Protocol protocol;
    XMPPConnection connection;

    @Before
    public void setup() throws XMPPException, SmackException, InterruptedException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection(this.protocol, initiatorJID, xmppServer);
    }

    @Test
    public void shouldHaveOneManagerForEveryConnection() {
        XMPPConnection connection1 = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        XMPPConnection connection2 = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        InBandBytestreamManager conn1ByteStreamManager1 = InBandBytestreamManager.getByteStreamManager((XMPPConnection)connection1);
        InBandBytestreamManager conn1ByteStreamManager2 = InBandBytestreamManager.getByteStreamManager((XMPPConnection)connection1);
        InBandBytestreamManager conn2ByteStreamManager1 = InBandBytestreamManager.getByteStreamManager((XMPPConnection)connection2);
        Assert.assertEquals((Object)conn1ByteStreamManager1, (Object)conn1ByteStreamManager2);
        Assert.assertNotSame((Object)conn1ByteStreamManager1, (Object)conn2ByteStreamManager1);
    }

    @Test
    public void shouldFailIfTargetDoesNotSupportIBB() throws SmackException, XMPPException, InterruptedException {
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        try {
            IQ errorIQ = IBBPacketUtils.createErrorIQ((Jid)targetJID, (Jid)initiatorJID, XMPPError.Condition.feature_not_implemented);
            this.protocol.addResponse((Stanza)errorIQ, new Verification[0]);
            byteStreamManager.establishSession((Jid)targetJID);
            Assert.fail((String)"exception should be thrown");
        }
        catch (XMPPException.XMPPErrorException e) {
            Assert.assertEquals((Object)XMPPError.Condition.feature_not_implemented, (Object)e.getXMPPError().getCondition());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowTooBigDefaultBlockSize() {
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        byteStreamManager.setDefaultBlockSize(1000000);
    }

    @Test
    public void shouldCorrectlySetDefaultBlockSize() {
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        byteStreamManager.setDefaultBlockSize(1024);
        Assert.assertEquals((long)1024L, (long)byteStreamManager.getDefaultBlockSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowTooBigMaximumBlockSize() {
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        byteStreamManager.setMaximumBlockSize(1000000);
    }

    @Test
    public void shouldCorrectlySetMaximumBlockSize() {
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        byteStreamManager.setMaximumBlockSize(1024);
        Assert.assertEquals((long)1024L, (long)byteStreamManager.getMaximumBlockSize());
    }

    @Test
    public void shouldUseConfiguredStanzaType() throws SmackException, InterruptedException {
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        byteStreamManager.setStanza(InBandBytestreamManager.StanzaType.MESSAGE);
        this.protocol.addResponse(null, new Verification<Open, IQ>(){

            @Override
            public void verify(Open request, IQ response) {
                Assert.assertEquals((Object)InBandBytestreamManager.StanzaType.MESSAGE, (Object)request.getStanza());
            }
        });
        try {
            byteStreamManager.establishSession((Jid)targetJID);
        }
        catch (XMPPException e) {
            this.protocol.verifyAll();
        }
    }

    @Test
    public void shouldReturnSession() throws Exception {
        InBandBytestreamManager byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        IQ success = IBBPacketUtils.createResultIQ((Jid)targetJID, (Jid)initiatorJID);
        this.protocol.addResponse((Stanza)success, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        InBandBytestreamSession session = byteStreamManager.establishSession((Jid)targetJID);
        Assert.assertNotNull((Object)session);
        Assert.assertNotNull((Object)session.getInputStream());
        Assert.assertNotNull((Object)session.getOutputStream());
        this.protocol.verifyAll();
    }
}

