/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5ClientForInitiator;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5TestProxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.jivesoftware.util.Verification;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class Socks5ClientForInitiatorTest {
    static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    static final DomainBareJid xmppServer = JidTestUtil.DOMAIN_BARE_JID_1;
    static final DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    String proxyAddress = "127.0.0.1";
    int proxyPort = 7890;
    String sessionID = "session_id";
    Protocol protocol;
    XMPPConnection connection;

    @Before
    public void setup() throws XMPPException, SmackException, InterruptedException {
        this.protocol = new Protocol();
        this.connection = ConnectionUtils.createMockedConnection(this.protocol, initiatorJID, xmppServer);
    }

    @Test
    public void shouldFailIfTargetIsNotConnectedToLocalSocks5Proxy() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyPort((int)this.proxyPort);
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        socks5Proxy.start();
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)this.connection.getUser(), (String)socks5Proxy.getLocalAddresses().get(0), socks5Proxy.getPort());
        String digest = Socks5Utils.createDigest((String)this.sessionID, (Jid)initiatorJID, (Jid)targetJID);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, (Jid)targetJID);
        try {
            socks5Client.getSocket(10000);
            Assert.fail((String)"exception should be thrown");
        }
        catch (SmackException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("target is not connected to SOCKS5 proxy"));
            this.protocol.verifyAll();
        }
        socks5Proxy.stop();
    }

    @Test
    public void shouldSuccessfullyConnectThroughLocalSocks5Proxy() throws Exception {
        Socks5Proxy.setLocalSocks5ProxyPort((int)this.proxyPort);
        Socks5Proxy socks5Proxy = Socks5Proxy.getSocks5Proxy();
        socks5Proxy.start();
        final byte[] data = new byte[]{1, 2, 3};
        final String digest = Socks5Utils.createDigest((String)this.sessionID, (Jid)initiatorJID, (Jid)targetJID);
        socks5Proxy.addTransfer(digest);
        final Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)this.connection.getUser(), (String)socks5Proxy.getLocalAddresses().get(0), socks5Proxy.getPort());
        Thread targetThread = new Thread(){

            @Override
            public void run() {
                try {
                    Socks5Client targetClient = new Socks5Client(streamHost, digest);
                    Socket socket = targetClient.getSocket(10000);
                    socket.getOutputStream().write(data);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        targetThread.start();
        Thread.sleep(200L);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, (Jid)targetJID);
        Socket socket = socks5Client.getSocket(10000);
        InputStream in = socket.getInputStream();
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((long)data[i], (long)in.read());
        }
        targetThread.join();
        this.protocol.verifyAll();
        socks5Proxy.removeTransfer(digest);
        socks5Proxy.stop();
    }

    @Test
    public void shouldFailIfActivateSocks5ProxyFails() throws Exception {
        ErrorIQ error = new ErrorIQ(XMPPError.getBuilder((XMPPError.Condition)XMPPError.Condition.internal_server_error));
        error.setFrom((Jid)proxyJID);
        error.setTo((Jid)initiatorJID);
        this.protocol.addResponse((Stanza)error, Verification.correspondingSenderReceiver, Verification.requestTypeSET);
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(this.proxyPort);
        socks5Proxy.start();
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)proxyJID, Socks5TestProxy.getAddress(), socks5Proxy.getPort());
        String digest = Socks5Utils.createDigest((String)this.sessionID, (Jid)initiatorJID, (Jid)targetJID);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, (Jid)targetJID);
        try {
            socks5Client.getSocket(10000);
            Assert.fail((String)"exception should be thrown");
        }
        catch (XMPPException.XMPPErrorException e) {
            Assert.assertTrue((boolean)XMPPError.Condition.internal_server_error.equals((Object)e.getXMPPError().getCondition()));
            this.protocol.verifyAll();
        }
        socks5Proxy.stop();
    }

    @Test
    public void shouldSuccessfullyEstablishConnectionAndActivateSocks5Proxy() throws Exception {
        EmptyResultIQ activationResponse = new EmptyResultIQ();
        activationResponse.setFrom((Jid)proxyJID);
        activationResponse.setTo((Jid)initiatorJID);
        this.protocol.addResponse((Stanza)activationResponse, Verification.correspondingSenderReceiver, Verification.requestTypeSET, new Verification<Bytestream, IQ>(){

            @Override
            public void verify(Bytestream request, IQ response) {
                Assert.assertNotNull((Object)request.getToActivate());
                Assert.assertEquals((Object)targetJID, (Object)request.getToActivate().getTarget());
            }
        });
        Socks5TestProxy socks5Proxy = Socks5TestProxy.getProxy(this.proxyPort);
        socks5Proxy.start();
        Bytestream.StreamHost streamHost = new Bytestream.StreamHost((Jid)proxyJID, Socks5TestProxy.getAddress(), socks5Proxy.getPort());
        String digest = Socks5Utils.createDigest((String)this.sessionID, (Jid)initiatorJID, (Jid)targetJID);
        Socks5ClientForInitiator socks5Client = new Socks5ClientForInitiator(streamHost, digest, this.connection, this.sessionID, (Jid)targetJID);
        Socket initiatorSocket = socks5Client.getSocket(10000);
        InputStream in = initiatorSocket.getInputStream();
        Socket targetSocket = socks5Proxy.getSocket(digest);
        OutputStream out = targetSocket.getOutputStream();
        for (int i = 0; i < 10; ++i) {
            out.write(i);
            Assert.assertEquals((long)i, (long)in.read());
        }
        this.protocol.verifyAll();
        initiatorSocket.close();
        targetSocket.close();
        socks5Proxy.stop();
    }

    @After
    public void cleanup() {
        Socks5Proxy.setLocalSocks5ProxyPort((int)7777);
    }
}

