/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatavalidation.provider;

import java.io.IOException;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smackx.xdatavalidation.packet.ValidateElement;
import org.jivesoftware.smackx.xdatavalidation.provider.DataValidationProvider;
import org.junit.Assert;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DataValidationTest {
    private static final String TEST_INPUT_MIN = "<validate xmlns='http://jabber.org/protocol/xdata-validate'></validate>";
    private static final String TEST_OUTPUT_MIN = "<validate xmlns='http://jabber.org/protocol/xdata-validate'><basic/></validate>";
    private static final String TEST_OUTPUT_RANGE = "<validate xmlns='http://jabber.org/protocol/xdata-validate' datatype='xs:string'><range min='min-val' max='max-val'/><list-range min='111' max='999'/></validate>";
    private static final String TEST_OUTPUT_RANGE2 = "<validate xmlns='http://jabber.org/protocol/xdata-validate'><range/></validate>";
    private static final String TEST_OUTPUT_FAIL = "<validate xmlns='http://jabber.org/protocol/xdata-validate'><list-range min='1-1-1' max='999'/></validate>";

    @Test
    public void testMin() throws XmlPullParserException, IOException {
        ValidateElement.BasicValidateElement dv = new ValidateElement.BasicValidateElement(null);
        Assert.assertNotNull((Object)dv.toXML());
        String output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_MIN, (Object)output);
        XmlPullParser parser = DataValidationTest.getParser(TEST_INPUT_MIN);
        dv = DataValidationProvider.parse((XmlPullParser)parser);
        Assert.assertNotNull((Object)dv);
        Assert.assertEquals((Object)"xs:string", (Object)dv.getDatatype());
        Assert.assertTrue((boolean)(dv instanceof ValidateElement.BasicValidateElement));
        Assert.assertNotNull((Object)dv.toXML());
        output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_MIN, (Object)output);
    }

    @Test
    public void testRange() throws XmlPullParserException, IOException {
        ValidateElement.RangeValidateElement dv = new ValidateElement.RangeValidateElement("xs:string", "min-val", "max-val");
        ValidateElement.ListRange listRange = new ValidateElement.ListRange(Long.valueOf(111L), Long.valueOf(999L));
        dv.setListRange(listRange);
        Assert.assertNotNull((Object)dv.toXML());
        String output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE, (Object)output);
        XmlPullParser parser = DataValidationTest.getParser(output);
        dv = DataValidationProvider.parse((XmlPullParser)parser);
        Assert.assertNotNull((Object)dv);
        Assert.assertEquals((Object)"xs:string", (Object)dv.getDatatype());
        Assert.assertTrue((boolean)(dv instanceof ValidateElement.RangeValidateElement));
        ValidateElement.RangeValidateElement rdv = dv;
        Assert.assertEquals((Object)"min-val", (Object)rdv.getMin());
        Assert.assertEquals((Object)"max-val", (Object)rdv.getMax());
        Assert.assertNotNull((Object)rdv.getListRange());
        Assert.assertEquals((Object)new Long(111L), (Object)rdv.getListRange().getMin());
        Assert.assertEquals((long)999L, (long)rdv.getListRange().getMax().intValue());
        Assert.assertNotNull((Object)dv.toXML());
        output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE, (Object)output);
    }

    @Test
    public void testRange2() throws XmlPullParserException, IOException {
        ValidateElement.RangeValidateElement dv = new ValidateElement.RangeValidateElement(null, null, null);
        Assert.assertNotNull((Object)dv.toXML());
        String output = dv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE2, (Object)output);
        XmlPullParser parser = DataValidationTest.getParser(output);
        dv = DataValidationProvider.parse((XmlPullParser)parser);
        Assert.assertNotNull((Object)dv);
        Assert.assertEquals((Object)"xs:string", (Object)dv.getDatatype());
        Assert.assertTrue((boolean)(dv instanceof ValidateElement.RangeValidateElement));
        ValidateElement.RangeValidateElement rdv = dv;
        Assert.assertEquals(null, (Object)rdv.getMin());
        Assert.assertEquals(null, (Object)rdv.getMax());
        Assert.assertNotNull((Object)rdv.toXML());
        output = rdv.toXML().toString();
        Assert.assertEquals((Object)TEST_OUTPUT_RANGE2, (Object)output);
    }

    @Test(expected=NumberFormatException.class)
    public void testRangeFailure() throws IOException, XmlPullParserException {
        XmlPullParser parser = DataValidationTest.getParser(TEST_OUTPUT_FAIL);
        DataValidationProvider.parse((XmlPullParser)parser);
    }

    private static XmlPullParser getParser(String output) throws XmlPullParserException, IOException {
        return TestUtils.getParser((String)output, (String)"validate");
    }
}

