/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chatstates;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.jivesoftware.smackx.chatstates.ChatStateListener;
import org.jivesoftware.smackx.chatstates.packet.ChatStateExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public final class ChatStateManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/chatstates";
    private static final Map<XMPPConnection, ChatStateManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatStateManager>();
    private static final StanzaFilter filter = new NotFilter((StanzaFilter)new StanzaExtensionFilter("http://jabber.org/protocol/chatstates"));
    private final OutgoingMessageInterceptor outgoingInterceptor = new OutgoingMessageInterceptor();
    private final IncomingMessageInterceptor incomingInterceptor = new IncomingMessageInterceptor();
    private final Map<Chat, ChatState> chatStates = new WeakHashMap<Chat, ChatState>();
    private final ChatManager chatManager;

    public static synchronized ChatStateManager getInstance(XMPPConnection connection) {
        ChatStateManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new ChatStateManager(connection);
        }
        return manager;
    }

    private ChatStateManager(XMPPConnection connection) {
        super(connection);
        this.chatManager = ChatManager.getInstanceFor((XMPPConnection)connection);
        this.chatManager.addOutgoingMessageInterceptor((MessageListener)this.outgoingInterceptor, filter);
        this.chatManager.addChatListener((ChatManagerListener)this.incomingInterceptor);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(NAMESPACE);
        INSTANCES.put(connection, this);
    }

    public void setCurrentState(ChatState newState, Chat chat) throws SmackException.NotConnectedException, InterruptedException {
        if (chat == null || newState == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (!this.updateChatState(chat, newState)) {
            return;
        }
        Message message = new Message();
        ChatStateExtension extension = new ChatStateExtension(newState);
        message.addExtension((ExtensionElement)extension);
        chat.sendMessage(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ChatStateManager that = (ChatStateManager)((Object)o);
        return this.connection().equals(that.connection());
    }

    public int hashCode() {
        return this.connection().hashCode();
    }

    private synchronized boolean updateChatState(Chat chat, ChatState newState) {
        ChatState lastChatState = this.chatStates.get(chat);
        if (lastChatState != newState) {
            this.chatStates.put(chat, newState);
            return true;
        }
        return false;
    }

    private static void fireNewChatState(Chat chat, ChatState state, Message message) {
        for (ChatMessageListener listener : chat.getListeners()) {
            if (!(listener instanceof ChatStateListener)) continue;
            ((ChatStateListener)listener).stateChanged(chat, state, message);
        }
    }

    private class IncomingMessageInterceptor
    implements ChatManagerListener,
    ChatMessageListener {
        private IncomingMessageInterceptor() {
        }

        public void chatCreated(Chat chat, boolean createdLocally) {
            chat.addMessageListener((ChatMessageListener)this);
        }

        public void processMessage(Chat chat, Message message) {
            ChatState state;
            ExtensionElement extension = message.getExtension(ChatStateManager.NAMESPACE);
            if (extension == null) {
                return;
            }
            try {
                state = ChatState.valueOf(extension.getElementName());
            }
            catch (Exception ex) {
                return;
            }
            ChatStateManager.fireNewChatState(chat, state, message);
        }
    }

    private class OutgoingMessageInterceptor
    implements MessageListener {
        private OutgoingMessageInterceptor() {
        }

        public void processMessage(Message message) {
            Chat chat = ChatStateManager.this.chatManager.getThreadChat(message.getThread());
            if (chat == null) {
                return;
            }
            if (ChatStateManager.this.updateChatState(chat, ChatState.active)) {
                message.addExtension((ExtensionElement)new ChatStateExtension(ChatState.active));
            }
        }
    }
}

