/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.custommonkey.xmlunit.XMLAssert;
import org.jivesoftware.smack.ThreadedDummyConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.InitExtensions;
import org.jivesoftware.smackx.pubsub.EventElement;
import org.jivesoftware.smackx.pubsub.EventElementType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.ItemsExtension;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.SimplePayload;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xmlpull.v1.XmlPullParser;

public class ItemValidationTest
extends InitExtensions {
    private ThreadedDummyConnection connection;

    @Before
    public void setUp() throws Exception {
        this.connection = new ThreadedDummyConnection();
        this.connection.connect();
        this.connection.login();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void verifyBasicItem() throws Exception {
        Item simpleItem = new Item();
        String simpleCtrl = "<item />";
        XMLAssert.assertXMLEqual((String)simpleCtrl, (String)simpleItem.toXML());
        Item idItem = new Item("uniqueid");
        String idCtrl = "<item id='uniqueid'/>";
        XMLAssert.assertXMLEqual((String)idCtrl, (String)idItem.toXML());
        Item itemWithNodeId = new Item("testId", "testNode");
        String nodeIdCtrl = "<item id='testId' node='testNode' />";
        XMLAssert.assertXMLEqual((String)nodeIdCtrl, (String)itemWithNodeId.toXML());
    }

    @Test
    public void verifyPayloadItem() throws Exception {
        SimplePayload payload = new SimplePayload(null, null, (CharSequence)"<data>This is the payload</data>");
        PayloadItem simpleItem = new PayloadItem((ExtensionElement)payload);
        String simpleCtrl = "<item>" + payload.toXML() + "</item>";
        XMLAssert.assertXMLEqual((String)simpleCtrl, (String)simpleItem.toXML());
        PayloadItem idItem = new PayloadItem("uniqueid", (ExtensionElement)payload);
        String idCtrl = "<item id='uniqueid'>" + payload.toXML() + "</item>";
        XMLAssert.assertXMLEqual((String)idCtrl, (String)idItem.toXML());
        PayloadItem itemWithNodeId = new PayloadItem("testId", "testNode", (ExtensionElement)payload);
        String nodeIdCtrl = "<item id='testId' node='testNode'>" + payload.toXML() + "</item>";
        XMLAssert.assertXMLEqual((String)nodeIdCtrl, (String)itemWithNodeId.toXML());
    }

    @Test
    public void parseBasicItem() throws Exception {
        XmlPullParser parser = PacketParserUtils.getParserFor((String)"<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' /></items></event></message>");
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.EVENT.getXmlns());
        Assert.assertTrue((boolean)(eventExt instanceof EventElement));
        EventElement event = (EventElement)eventExt;
        Assert.assertEquals((Object)EventElementType.items, (Object)event.getEventType());
        Assert.assertEquals((long)1L, (long)event.getExtensions().size());
        Assert.assertTrue((boolean)(event.getExtensions().get(0) instanceof ItemsExtension));
        Assert.assertEquals((long)1L, (long)((ItemsExtension)((ExtensionElement)event.getExtensions().get((int)0))).items.size());
        ExtensionElement itemExt = (ExtensionElement)((ItemsExtension)((ExtensionElement)event.getExtensions().get((int)0))).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof Item));
        Assert.assertEquals((Object)"testid1", (Object)((Item)itemExt).getId());
    }

    @Test
    public void parseSimplePayloadItem() throws Exception {
        String itemContent = "<foo xmlns='smack:test'>Some text</foo>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item>" + "</items>" + "</event>" + "</message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.EVENT.getXmlns());
        EventElement event = (EventElement)eventExt;
        ExtensionElement itemExt = (ExtensionElement)((ItemsExtension)((ExtensionElement)event.getExtensions().get((int)0))).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assert.assertEquals((Object)"testid1", (Object)item.getId());
        Assert.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        SimplePayload payload = (SimplePayload)item.getPayload();
        Assert.assertEquals((Object)"foo", (Object)payload.getElementName());
        Assert.assertEquals((Object)"smack:test", (Object)payload.getNamespace());
        XMLAssert.assertXMLEqual((String)itemContent, (String)payload.toXML().toString());
    }

    @Test
    public void parseComplexItem() throws Exception {
        String itemContent = "<entry xmlns='http://www.w3.org/2005/Atom'><title>Soliloquy</title><summary>To be, or not to be: that is the question:Whether 'tis nobler in the mind to sufferThe slings and arrows of outrageous fortune,Or to take arms against a sea of troubles,And by opposing end them?</summary><link rel='alternate' type='text/html' href='http://denmark.lit/2003/12/13/atom03'/><id>tag:denmark.lit,2003:entry-32397</id><published>2003-12-13T18:30:02Z</published><updated>2003-12-13T18:30:02Z</updated></entry>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item>" + "</items>" + "</event>" + "</message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.EVENT.getXmlns());
        EventElement event = (EventElement)eventExt;
        ExtensionElement itemExt = (ExtensionElement)((ItemsExtension)((ExtensionElement)event.getExtensions().get((int)0))).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assert.assertEquals((Object)"testid1", (Object)item.getId());
        Assert.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        SimplePayload payload = (SimplePayload)item.getPayload();
        Assert.assertEquals((Object)"entry", (Object)payload.getElementName());
        Assert.assertEquals((Object)"http://www.w3.org/2005/Atom", (Object)payload.getNamespace());
        XMLAssert.assertXMLEqual((String)itemContent, (String)payload.toXML().toString());
    }

    @Test
    public void parseEmptyTag() throws Exception {
        String itemContent = "<foo xmlns='smack:test'><bar/></foo>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)("<message from='pubsub.myserver.com' to='francisco@denmark.lit' id='foo'><event xmlns='http://jabber.org/protocol/pubsub#event'><items node='testNode'><item id='testid1' >" + itemContent + "</item>" + "</items>" + "</event>" + "</message>"));
        Message message = PacketParserUtils.parseMessage((XmlPullParser)parser);
        ExtensionElement eventExt = message.getExtension(PubSubNamespace.EVENT.getXmlns());
        Assert.assertTrue((boolean)(eventExt instanceof EventElement));
        EventElement event = (EventElement)eventExt;
        Assert.assertEquals((Object)EventElementType.items, (Object)event.getEventType());
        Assert.assertEquals((long)1L, (long)event.getExtensions().size());
        Assert.assertTrue((boolean)(event.getExtensions().get(0) instanceof ItemsExtension));
        Assert.assertEquals((long)1L, (long)((ItemsExtension)((ExtensionElement)event.getExtensions().get((int)0))).items.size());
        ExtensionElement itemExt = (ExtensionElement)((ItemsExtension)((ExtensionElement)event.getExtensions().get((int)0))).items.get(0);
        Assert.assertTrue((boolean)(itemExt instanceof PayloadItem));
        PayloadItem item = (PayloadItem)itemExt;
        Assert.assertEquals((Object)"testid1", (Object)item.getId());
        Assert.assertTrue((boolean)(item.getPayload() instanceof SimplePayload));
        XMLAssert.assertXMLEqual((String)itemContent, (String)((SimplePayload)item.getPayload()).toXML().toString());
    }
}

