/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.blocking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.blocking.element.BlockContactsIQ;
import org.jivesoftware.smackx.blocking.element.BlockListIQ;
import org.jivesoftware.smackx.blocking.element.UnblockContactsIQ;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.jid.Jid;

public final class BlockingCommandManager
extends Manager {
    public static final String NAMESPACE = "urn:xmpp:blocking";
    private volatile List<Jid> blockListCached;
    private static final Map<XMPPConnection, BlockingCommandManager> INSTANCES;

    public static synchronized BlockingCommandManager getInstanceFor(XMPPConnection connection) {
        BlockingCommandManager blockingCommandManager = INSTANCES.get(connection);
        if (blockingCommandManager == null) {
            blockingCommandManager = new BlockingCommandManager(connection);
            INSTANCES.put(connection, blockingCommandManager);
        }
        return blockingCommandManager;
    }

    private BlockingCommandManager(XMPPConnection connection) {
        super(connection);
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("block", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iqRequest) {
                BlockContactsIQ blockContactIQ = (BlockContactsIQ)iqRequest;
                if (BlockingCommandManager.this.blockListCached == null) {
                    BlockingCommandManager.this.blockListCached = new ArrayList();
                }
                List<Jid> blockedJids = blockContactIQ.getJids();
                BlockingCommandManager.this.blockListCached.addAll(blockedJids);
                return IQ.createResultIQ((IQ)blockContactIQ);
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("unblock", NAMESPACE, IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iqRequest) {
                List<Jid> unblockedJids;
                UnblockContactsIQ unblockContactIQ = (UnblockContactsIQ)iqRequest;
                if (BlockingCommandManager.this.blockListCached == null) {
                    BlockingCommandManager.this.blockListCached = new ArrayList();
                }
                if ((unblockedJids = unblockContactIQ.getJids()) == null) {
                    BlockingCommandManager.this.blockListCached.clear();
                } else {
                    BlockingCommandManager.this.blockListCached.removeAll(unblockedJids);
                }
                return IQ.createResultIQ((IQ)unblockContactIQ);
            }
        });
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (resumed) {
                    return;
                }
                BlockingCommandManager.this.blockListCached = null;
            }
        });
    }

    public boolean isSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature(NAMESPACE);
    }

    public List<Jid> getBlockList() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.blockListCached != null) {
            return Collections.unmodifiableList(this.blockListCached);
        }
        BlockListIQ blockListIQ = new BlockListIQ();
        BlockListIQ blockListIQResult = (BlockListIQ)this.connection().createPacketCollectorAndSend((IQ)blockListIQ).nextResultOrThrow();
        this.blockListCached = blockListIQResult.getBlockedJidsCopy();
        return Collections.unmodifiableList(this.blockListCached);
    }

    public void blockContacts(List<Jid> jids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        BlockContactsIQ blockContactIQ = new BlockContactsIQ(jids);
        this.connection().createPacketCollectorAndSend((IQ)blockContactIQ).nextResultOrThrow();
    }

    public void unblockContacts(List<Jid> jids) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UnblockContactsIQ unblockContactIQ = new UnblockContactsIQ(jids);
        this.connection().createPacketCollectorAndSend((IQ)unblockContactIQ).nextResultOrThrow();
    }

    public void unblockAll() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        UnblockContactsIQ unblockContactIQ = new UnblockContactsIQ();
        this.connection().createPacketCollectorAndSend((IQ)unblockContactIQ).nextResultOrThrow();
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                BlockingCommandManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, BlockingCommandManager>();
    }
}

