/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_correct;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.message_correct.element.MessageCorrectExtension;
import org.junit.Assert;
import org.junit.Test;

public class MessageCorrectExtensionTest {
    private final String idInitialMessage = "bad1";
    private final String initialMessageXml = "<message to='juliet@capulet.net/balcony' id='good1'><body>But soft, what light through yonder window breaks?</body></message>";
    private final CharSequence messageCorrectionXml = "<replace xmlns='urn:xmpp:message-correct:0' id='bad1'/>";
    private final CharSequence expectedXml = "<message to='juliet@capulet.net/balcony' id='good1'><body>But soft, what light through yonder window breaks?</body><replace xmlns='urn:xmpp:message-correct:0' id='bad1'/></message>";

    @Test
    public void checkStanzas() throws Exception {
        Message initialMessage = (Message)PacketParserUtils.parseStanza((String)"<message to='juliet@capulet.net/balcony' id='good1'><body>But soft, what light through yonder window breaks?</body></message>");
        MessageCorrectExtension messageCorrectExtension = new MessageCorrectExtension("bad1");
        Assert.assertEquals((Object)messageCorrectExtension.toXML().toString(), (Object)this.messageCorrectionXml);
        initialMessage.addExtension((ExtensionElement)messageCorrectExtension);
        Assert.assertEquals((Object)initialMessage.toXML(), (Object)this.expectedXml);
    }
}

