/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.blocking;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.blocking.element.BlockListIQ;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.impl.JidCreate;

public class GetBlockingListTest {
    String getBlockingListIQExample = "<iq id='blocklist1' type='get'><blocklist xmlns='urn:xmpp:blocking'/></iq>";
    String blockListIQExample = "<iq type='result' id='blocklist1'><blocklist xmlns='urn:xmpp:blocking'><item jid='romeo@montague.net'/><item jid='iago@shakespeare.lit'/></blocklist></iq>";
    String emptyBlockListIQExample = "<iq type='result' id='blocklist1'><blocklist xmlns='urn:xmpp:blocking'/></iq>";

    @Test
    public void checkGetBlockingListIQStanza() throws Exception {
        BlockListIQ getBlockListIQ = new BlockListIQ(null);
        getBlockListIQ.setType(IQ.Type.get);
        getBlockListIQ.setStanzaId("blocklist1");
        Assert.assertEquals((Object)this.getBlockingListIQExample, (Object)getBlockListIQ.toXML().toString());
    }

    @Test
    public void checkBlockListIQ() throws Exception {
        IQ iq = (IQ)PacketParserUtils.parseStanza((String)this.blockListIQExample);
        BlockListIQ blockListIQ = (BlockListIQ)iq;
        Assert.assertEquals((long)2L, (long)blockListIQ.getBlockedJids().size());
        Assert.assertEquals((Object)JidCreate.from((String)"romeo@montague.net"), blockListIQ.getBlockedJids().get(0));
        Assert.assertEquals((Object)JidCreate.from((String)"iago@shakespeare.lit"), blockListIQ.getBlockedJids().get(1));
        IQ iq2 = (IQ)PacketParserUtils.parseStanza((String)this.emptyBlockListIQExample);
        BlockListIQ emptyBlockListIQ = (BlockListIQ)iq2;
        Assert.assertEquals((long)0L, (long)emptyBlockListIQ.getBlockedJids().size());
    }
}

