/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.BoBHash;
import org.jivesoftware.smackx.bob.element.BoBIQ;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.impl.JidCreate;

public class BoBIQTest
extends SmackTestSuite {
    String sampleBoBIQRequest = "<iq to='ladymacbeth@shakespeare.lit/castle' id='sarasa' type='get'><data xmlns='urn:xmpp:bob' cid='sha1+8f35fef110ffc5df08d579a50083ff9308fb6242@bob.xmpp.org'/></iq>";
    String sampleBoBIQResponse = "<iq to='doctor@shakespeare.lit/pda' id='sarasa' type='result'><data xmlns='urn:xmpp:bob' cid='sha1+8f35fef110ffc5df08d579a50083ff9308fb6242@bob.xmpp.org' max-age='86400' type='image/png'>c2FyYXNhZGUyMzU0ajI=</data></iq>";

    @Test
    public void checkBoBIQRequest() throws Exception {
        BoBHash bobHash = new BoBHash("8f35fef110ffc5df08d579a50083ff9308fb6242", "sha1");
        BoBIQ createdBoBIQ = new BoBIQ(bobHash);
        createdBoBIQ.setStanzaId("sarasa");
        createdBoBIQ.setTo(JidCreate.from((String)"ladymacbeth@shakespeare.lit/castle"));
        createdBoBIQ.setType(IQ.Type.get);
        Assert.assertEquals((Object)this.sampleBoBIQRequest, (Object)createdBoBIQ.toXML().toString());
    }

    @Test
    public void checkBoBIQResponse() throws Exception {
        BoBIQ bobIQ = (BoBIQ)PacketParserUtils.parseStanza((String)this.sampleBoBIQResponse);
        BoBHash bobHash = new BoBHash("8f35fef110ffc5df08d579a50083ff9308fb6242", "sha1");
        BoBData bobData = new BoBData("image/png", "sarasade2354j2".getBytes("UTF-8"), 86400);
        BoBIQ createdBoBIQ = new BoBIQ(bobHash, bobData);
        createdBoBIQ.setStanzaId("sarasa");
        createdBoBIQ.setTo(JidCreate.from((String)"doctor@shakespeare.lit/pda"));
        createdBoBIQ.setType(IQ.Type.result);
        Assert.assertEquals((Object)bobIQ.getBoBHash().getHash(), (Object)createdBoBIQ.getBoBHash().getHash());
        Assert.assertEquals((Object)bobIQ.getBoBHash().getHashType(), (Object)createdBoBIQ.getBoBHash().getHashType());
        Assert.assertEquals((long)bobIQ.getBoBData().getMaxAge(), (long)createdBoBIQ.getBoBData().getMaxAge());
        Assert.assertEquals((Object)bobIQ.getBoBData().getType(), (Object)createdBoBIQ.getBoBData().getType());
        Assert.assertEquals((Object)bobIQ.getBoBData().getContentBase64Encoded(), (Object)createdBoBIQ.getBoBData().getContentBase64Encoded());
        Assert.assertEquals((Object)bobIQ.toXML().toString(), (Object)createdBoBIQ.toXML().toString());
    }
}

